/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.liteflow.flow.element;

import com.jxdinfo.hutool.core.text.StrFormatter;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.liteflow.core.NodeComponent;
import com.jxdinfo.liteflow.enums.ConditionTypeEnum;
import com.jxdinfo.liteflow.enums.NodeTypeEnum;
import com.jxdinfo.liteflow.exception.FallbackCmpNotFoundException;
import com.jxdinfo.liteflow.exception.FlowSystemException;
import com.jxdinfo.liteflow.flow.FlowBus;
import com.jxdinfo.liteflow.flow.element.Condition;
import com.jxdinfo.liteflow.flow.element.Executable;
import com.jxdinfo.liteflow.flow.element.Node;
import com.jxdinfo.liteflow.flow.element.condition.ForCondition;
import com.jxdinfo.liteflow.flow.element.condition.IfCondition;
import com.jxdinfo.liteflow.flow.element.condition.IteratorCondition;
import com.jxdinfo.liteflow.flow.element.condition.LoopCondition;
import com.jxdinfo.liteflow.flow.element.condition.SwitchCondition;
import com.jxdinfo.liteflow.flow.element.condition.WhileCondition;
import com.jxdinfo.liteflow.slot.DataBus;
import com.jxdinfo.liteflow.slot.Slot;

public class FallbackNode
extends Node {
    private String expectedNodeId;
    private Node fallbackNode;

    public FallbackNode() {
        this.setType(NodeTypeEnum.FALLBACK);
    }

    public FallbackNode(String expectedNodeId) {
        this();
        this.expectedNodeId = expectedNodeId;
    }

    @Override
    public void execute(Integer slotIndex) throws Exception {
        Node node = FlowBus.getNode(this.expectedNodeId);
        if (node != null) {
            this.fallbackNode = node;
        } else {
            this.loadFallBackNode(slotIndex);
        }
        this.fallbackNode.setCurrChainId(this.getCurrChainId());
        this.fallbackNode.execute(slotIndex);
    }

    private void loadFallBackNode(Integer slotIndex) throws Exception {
        if (ObjectUtil.isNotNull(this.fallbackNode)) {
            return;
        }
        Slot slot = DataBus.getSlot(slotIndex);
        Condition curCondition = slot.getCurrentCondition();
        if (ObjectUtil.isNull(curCondition)) {
            throw new FlowSystemException("The current executing condition could not be found.");
        }
        Node node = this.findFallbackNode(curCondition);
        if (ObjectUtil.isNull(node)) {
            throw new FallbackCmpNotFoundException(StrFormatter.format("No fallback component found for [{}] in chain[{}].", this.expectedNodeId, this.getCurrChainId()));
        }
        this.fallbackNode = node.clone();
    }

    private Node findFallbackNode(Condition condition) {
        ConditionTypeEnum conditionType = condition.getConditionType();
        switch (conditionType) {
            case TYPE_THEN: 
            case TYPE_WHEN: 
            case TYPE_PRE: 
            case TYPE_FINALLY: 
            case TYPE_CATCH: {
                return FlowBus.getFallBackNode(NodeTypeEnum.COMMON);
            }
            case TYPE_IF: {
                return this.findNodeInIf((IfCondition)condition);
            }
            case TYPE_SWITCH: {
                return this.findNodeInSwitch((SwitchCondition)condition);
            }
            case TYPE_FOR: {
                return this.findNodeInFor((ForCondition)condition);
            }
            case TYPE_WHILE: {
                return this.findNodeInWhile((WhileCondition)condition);
            }
            case TYPE_ITERATOR: {
                return this.findNodeInIterator((IteratorCondition)condition);
            }
            case TYPE_NOT_OPT: 
            case TYPE_AND_OR_OPT: {
                return FlowBus.getFallBackNode(NodeTypeEnum.BOOLEAN);
            }
        }
        return null;
    }

    private Node findNodeInIf(IfCondition ifCondition) {
        Executable ifItem = ifCondition.getIfItem();
        if (ifItem == this) {
            return FlowBus.getFallBackNode(NodeTypeEnum.BOOLEAN);
        }
        return FlowBus.getFallBackNode(NodeTypeEnum.COMMON);
    }

    private Node findNodeInSwitch(SwitchCondition switchCondition) {
        Node switchNode = switchCondition.getSwitchNode();
        if (switchNode == this) {
            return FlowBus.getFallBackNode(NodeTypeEnum.SWITCH);
        }
        return FlowBus.getFallBackNode(NodeTypeEnum.COMMON);
    }

    private Node findNodeInFor(ForCondition forCondition) {
        Node forNode = forCondition.getForNode();
        if (forNode == this) {
            return FlowBus.getFallBackNode(NodeTypeEnum.FOR);
        }
        return this.findNodeInLoop(forCondition);
    }

    private Node findNodeInWhile(WhileCondition whileCondition) {
        Executable whileItem = whileCondition.getWhileItem();
        if (whileItem == this) {
            return FlowBus.getFallBackNode(NodeTypeEnum.BOOLEAN);
        }
        return this.findNodeInLoop(whileCondition);
    }

    private Node findNodeInIterator(IteratorCondition iteratorCondition) {
        Node iteratorNode = iteratorCondition.getIteratorNode();
        if (iteratorNode == this) {
            return FlowBus.getFallBackNode(NodeTypeEnum.ITERATOR);
        }
        return this.findNodeInLoop(iteratorCondition);
    }

    private Node findNodeInLoop(LoopCondition loopCondition) {
        Executable breakItem = loopCondition.getExecutableOne("BREAK_KEY");
        if (breakItem == this) {
            return FlowBus.getFallBackNode(NodeTypeEnum.BOOLEAN);
        }
        return FlowBus.getFallBackNode(NodeTypeEnum.COMMON);
    }

    @Override
    public <T> T getItemResultMetaValue(Integer slotIndex) {
        return this.fallbackNode.getItemResultMetaValue(slotIndex);
    }

    @Override
    public boolean isAccess(Integer slotIndex) throws Exception {
        this.loadFallBackNode(slotIndex);
        return this.fallbackNode.isAccess(slotIndex);
    }

    @Override
    public NodeComponent getInstance() {
        if (this.fallbackNode == null) {
            return null;
        }
        return this.fallbackNode.getInstance();
    }

    @Override
    public String getId() {
        return this.fallbackNode == null ? null : this.fallbackNode.getId();
    }

    @Override
    public Node clone() {
        return this;
    }

    @Override
    public NodeTypeEnum getType() {
        return NodeTypeEnum.FALLBACK;
    }

    public String getExpectedNodeId() {
        return this.expectedNodeId;
    }

    public void setExpectedNodeId(String expectedNodeId) {
        this.expectedNodeId = expectedNodeId;
    }
}

