/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.util;

import com.jxdinfo.hutool.core.text.ASCIIStrCache;
import com.jxdinfo.hutool.core.text.CharPool;

public class CharUtil
implements CharPool {
    public static boolean isLetter(char ch) {
        return CharUtil.isLetterUpper(ch) || CharUtil.isLetterLower(ch);
    }

    public static boolean isLetterUpper(char ch) {
        return ch >= 'A' && ch <= 'Z';
    }

    public static boolean isLetterLower(char ch) {
        return ch >= 'a' && ch <= 'z';
    }

    public static boolean isNumber(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isHexChar(char c) {
        return CharUtil.isNumber(c) || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    public static String toString(char c) {
        return ASCIIStrCache.toString(c);
    }

    public static boolean isChar(Object value) {
        return value instanceof Character || value.getClass() == Character.TYPE;
    }

    public static boolean isBlankChar(char c) {
        return CharUtil.isBlankChar((int)c);
    }

    public static boolean isBlankChar(int c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c) || c == 65279 || c == 8234 || c == 0 || c == 12644 || c == 10240 || c == 6158;
    }

    public static boolean isFileSeparator(char c) {
        return '/' == c || '\\' == c;
    }

    public static boolean equals(char c1, char c2, boolean caseInsensitive) {
        if (caseInsensitive) {
            return Character.toLowerCase(c1) == Character.toLowerCase(c2);
        }
        return c1 == c2;
    }

    public static int digit16(int b) {
        return Character.digit(b, 16);
    }
}

