/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.annotation;

import com.jxdinfo.hutool.core.annotation.CombinationAnnotationElement;
import com.jxdinfo.hutool.core.annotation.GenericSynthesizedAggregateAnnotation;
import com.jxdinfo.hutool.core.annotation.SynthesizedAggregateAnnotation;
import com.jxdinfo.hutool.core.annotation.SynthesizedAnnotationProxy;
import com.jxdinfo.hutool.core.annotation.scanner.AnnotationScanner;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.lang.Opt;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.ReflectUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;

public class AnnotationUtil {
    static final Set<Class<? extends Annotation>> META_ANNOTATIONS = CollUtil.newHashSet(Target.class, Retention.class, Inherited.class, Documented.class, SuppressWarnings.class, Override.class, Deprecated.class);

    public static boolean isJdkMetaAnnotation(Class<? extends Annotation> annotationType) {
        return META_ANNOTATIONS.contains(annotationType);
    }

    public static boolean isNotJdkMateAnnotation(Class<? extends Annotation> annotationType) {
        return !AnnotationUtil.isJdkMetaAnnotation(annotationType);
    }

    public static CombinationAnnotationElement toCombination(AnnotatedElement annotationEle) {
        if (annotationEle instanceof CombinationAnnotationElement) {
            return (CombinationAnnotationElement)annotationEle;
        }
        return new CombinationAnnotationElement(annotationEle);
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination) {
        return AnnotationUtil.getAnnotations(annotationEle, isToCombination, (Predicate<Annotation>)null);
    }

    public static <T> T[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Class<T> annotationType) {
        Annotation[] annotations = AnnotationUtil.getAnnotations(annotationEle, isToCombination, (Annotation annotation) -> null == annotationType || annotationType.isAssignableFrom(annotation.getClass()));
        T[] result = ArrayUtil.newArray(annotationType, annotations.length);
        for (int i = 0; i < annotations.length; ++i) {
            result[i] = annotations[i];
        }
        return result;
    }

    public static Annotation[] getAnnotations(AnnotatedElement annotationEle, boolean isToCombination, Predicate<Annotation> predicate) {
        if (null == annotationEle) {
            return null;
        }
        if (isToCombination) {
            if (null == predicate) {
                return AnnotationUtil.toCombination(annotationEle).getAnnotations();
            }
            return CombinationAnnotationElement.of(annotationEle, predicate).getAnnotations();
        }
        Annotation[] result = annotationEle.getAnnotations();
        if (null == predicate) {
            return result;
        }
        return ArrayUtil.filter(result, predicate::test);
    }

    public static <A extends Annotation> A getAnnotation(AnnotatedElement annotationEle, Class<A> annotationType) {
        return null == annotationEle ? null : (A)AnnotationUtil.toCombination(annotationEle).getAnnotation(annotationType);
    }

    public static boolean hasAnnotation(AnnotatedElement annotationEle, Class<? extends Annotation> annotationType) {
        return null != AnnotationUtil.getAnnotation(annotationEle, annotationType);
    }

    public static ElementType[] getTargetType(Class<? extends Annotation> annotationType) {
        Target target = annotationType.getAnnotation(Target.class);
        if (null == target) {
            return new ElementType[]{ElementType.TYPE, ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.CONSTRUCTOR, ElementType.LOCAL_VARIABLE, ElementType.ANNOTATION_TYPE, ElementType.PACKAGE};
        }
        return target.value();
    }

    public static void setValue(Annotation annotation, String annotationField, Object value) {
        Map memberValues = (Map)ReflectUtil.getFieldValue((Object)Proxy.getInvocationHandler(annotation), "memberValues");
        memberValues.put(annotationField, value);
    }

    public static boolean isSynthesizedAnnotation(Annotation annotation) {
        return SynthesizedAnnotationProxy.isProxyAnnotation(annotation.getClass());
    }

    public static <T extends Annotation> T getSynthesizedAnnotation(Class<T> annotationType, Annotation ... annotations) {
        return (T)Opt.ofNullable(annotations).filter(ArrayUtil::isNotEmpty).map(AnnotationUtil::aggregatingFromAnnotationWithMeta).map(a -> a.synthesize(annotationType)).get();
    }

    public static <T extends Annotation> T getSynthesizedAnnotation(AnnotatedElement annotatedEle, Class<T> annotationType) {
        T target = annotatedEle.getAnnotation(annotationType);
        if (ObjectUtil.isNotNull(target)) {
            return target;
        }
        return (T)((Annotation)AnnotationScanner.DIRECTLY.getAnnotationsIfSupport(annotatedEle).stream().map(annotation -> AnnotationUtil.getSynthesizedAnnotation(annotationType, annotation)).filter(Objects::nonNull).findFirst().orElse(null));
    }

    public static SynthesizedAggregateAnnotation aggregatingFromAnnotationWithMeta(Annotation ... annotations) {
        return new GenericSynthesizedAggregateAnnotation(Arrays.asList(annotations), AnnotationScanner.DIRECTLY_AND_META_ANNOTATION);
    }

    static boolean isAttributeMethod(Method method) {
        return method.getParameterCount() == 0 && method.getReturnType() != Void.TYPE;
    }
}

