/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.map;

import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.lang.Assert;
import com.jxdinfo.hutool.core.map.ForestMap;
import com.jxdinfo.hutool.core.map.TreeEntry;
import com.jxdinfo.hutool.core.util.ClassUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class LinkedForestMap<K, V>
implements ForestMap<K, V> {
    private final Map<K, TreeEntryNode<K, V>> nodes;
    private final boolean allowOverrideParent;

    public LinkedForestMap(boolean allowOverrideParent) {
        this.allowOverrideParent = allowOverrideParent;
        this.nodes = new LinkedHashMap<K, TreeEntryNode<K, V>>();
    }

    @Override
    public int size() {
        return this.nodes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nodes.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.nodes.containsValue(value);
    }

    @Override
    public TreeEntry<K, V> get(Object key) {
        return this.nodes.get(key);
    }

    @Override
    public TreeEntry<K, V> remove(Object key) {
        TreeEntryNode<K, V> target = this.nodes.remove(key);
        if (ObjectUtil.isNull(target)) {
            return null;
        }
        if (target.hasParent()) {
            TreeEntry parent = target.getDeclaredParent();
            Map<Object, TreeEntry<Object, TreeEntry>> targetChildren = target.getChildren();
            ((TreeEntryNode)parent).removeDeclaredChild(target.getKey());
            target.clear();
            targetChildren.forEach((arg_0, arg_1) -> LinkedForestMap.lambda$remove$132((TreeEntryNode)parent, arg_0, arg_1));
        }
        return target;
    }

    @Override
    public void clear() {
        this.nodes.values().forEach(TreeEntryNode::clear);
        this.nodes.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.nodes.keySet();
    }

    @Override
    public Collection<TreeEntry<K, V>> values() {
        return new ArrayList<TreeEntry<K, V>>(this.nodes.values());
    }

    @Override
    public Set<Map.Entry<K, TreeEntry<K, V>>> entrySet() {
        return this.nodes.entrySet().stream().map(this::wrap).collect(Collectors.toSet());
    }

    private Map.Entry<K, TreeEntry<K, V>> wrap(Map.Entry<K, TreeEntryNode<K, V>> nodeEntry) {
        return new EntryNodeWrapper(nodeEntry.getValue());
    }

    @Override
    public TreeEntryNode<K, V> putNode(K key, V value) {
        TreeEntryNode<K, V> target = this.nodes.get(key);
        if (ObjectUtil.isNotNull(target)) {
            V oldVal = target.getValue();
            target.setValue(value);
            return target.copy(oldVal);
        }
        target = new TreeEntryNode<K, V>(null, key, value);
        this.nodes.put(key, target);
        return null;
    }

    @Override
    public void putLinkedNodes(K parentKey, V parentValue, K childKey, V childValue) {
        this.linkNodes(parentKey, childKey, (parent, child) -> {
            parent.setValue(parentValue);
            child.setValue(childValue);
        });
    }

    @Override
    public void putLinkedNodes(K parentKey, K childKey, V childValue) {
        this.linkNodes(parentKey, childKey, (parent, child) -> child.setValue(childValue));
    }

    @Override
    public void linkNodes(K parentKey, K childKey, BiConsumer<TreeEntry<K, V>, TreeEntry<K, V>> consumer) {
        consumer = ObjectUtil.defaultIfNull(consumer, (parent, child) -> {});
        TreeEntryNode parentNode = this.nodes.computeIfAbsent(parentKey, t -> new TreeEntryNode(null, t));
        TreeEntryNode<K, V> childNode = this.nodes.get(childKey);
        if (ObjectUtil.isNull(childNode)) {
            childNode = new TreeEntryNode(parentNode, childKey);
            consumer.accept(parentNode, childNode);
            this.nodes.put(childKey, childNode);
            return;
        }
        if (ObjectUtil.equals(parentNode, childNode.getDeclaredParent())) {
            consumer.accept(parentNode, childNode);
            return;
        }
        if (!childNode.hasParent()) {
            parentNode.addChild(childNode);
        } else if (this.allowOverrideParent) {
            ((TreeEntryNode)childNode.getDeclaredParent()).removeDeclaredChild(childNode.getKey());
            parentNode.addChild(childNode);
        } else {
            throw new IllegalArgumentException(StrUtil.format("[{}] has been used as child of [{}], can not be overwrite as child of [{}]", childNode.getKey(), ((TreeEntryNode)childNode.getDeclaredParent()).getKey(), parentKey));
        }
        consumer.accept(parentNode, childNode);
    }

    @Override
    public void unlinkNode(K parentKey, K childKey) {
        TreeEntryNode<K, V> childNode = this.nodes.get(childKey);
        if (ObjectUtil.isNull(childNode)) {
            return;
        }
        if (childNode.hasParent()) {
            ((TreeEntryNode)childNode.getDeclaredParent()).removeDeclaredChild(childNode.getKey());
        }
    }

    private static /* synthetic */ void lambda$remove$132(TreeEntryNode treeEntryNode, Object k, TreeEntry c) {
        treeEntryNode.addChild((TreeEntryNode)c);
    }

    public static class EntryNodeWrapper<K, V, N extends TreeEntry<K, V>>
    implements Map.Entry<K, TreeEntry<K, V>> {
        private final N entryNode;

        EntryNodeWrapper(N entryNode) {
            this.entryNode = entryNode;
        }

        @Override
        public K getKey() {
            return this.entryNode.getKey();
        }

        @Override
        public TreeEntry<K, V> getValue() {
            return this.entryNode;
        }

        @Override
        public TreeEntry<K, V> setValue(TreeEntry<K, V> value) {
            throw new UnsupportedOperationException();
        }
    }

    public static class TreeEntryNode<K, V>
    implements TreeEntry<K, V> {
        private TreeEntryNode<K, V> root;
        private TreeEntryNode<K, V> parent;
        private int weight;
        private final Map<K, TreeEntryNode<K, V>> children;
        private final K key;
        private V value;

        public TreeEntryNode(TreeEntryNode<K, V> parent, K key) {
            this(parent, key, null);
        }

        public TreeEntryNode(TreeEntryNode<K, V> parent, K key, V value) {
            this.parent = parent;
            this.key = key;
            this.value = value;
            this.children = new LinkedHashMap<K, TreeEntryNode<K, V>>();
            if (ObjectUtil.isNull(parent)) {
                this.root = this;
                this.weight = 0;
            } else {
                parent.addChild(this);
                this.weight = parent.weight + 1;
                this.root = parent.root;
            }
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public int getWeight() {
            return this.weight;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldVal = this.getValue();
            this.value = value;
            return oldVal;
        }

        TreeEntryNode<K, V> traverseParentNodes(boolean includeCurrent, Consumer<TreeEntryNode<K, V>> consumer, Predicate<TreeEntryNode<K, V>> breakTraverse) {
            TreeEntryNode<K, V> curr;
            breakTraverse = ObjectUtil.defaultIfNull(breakTraverse, a -> n -> false);
            TreeEntryNode<K, V> treeEntryNode = curr = includeCurrent ? this : this.parent;
            while (ObjectUtil.isNotNull(curr)) {
                consumer.accept(curr);
                if (breakTraverse.test(curr)) break;
                curr = curr.parent;
            }
            return curr;
        }

        public boolean isRoot() {
            return this.getRoot() == this;
        }

        @Override
        public TreeEntryNode<K, V> getRoot() {
            if (ObjectUtil.isNotNull(this.root)) {
                return this.root;
            }
            this.root = this.traverseParentNodes(true, p -> {}, p -> !p.hasParent());
            return this.root;
        }

        @Override
        public TreeEntryNode<K, V> getDeclaredParent() {
            return this.parent;
        }

        @Override
        public TreeEntryNode<K, V> getParent(K key) {
            return this.traverseParentNodes(false, p -> {}, p -> p.equalsKey(key));
        }

        @Override
        public void forEachChild(boolean includeSelf, Consumer<TreeEntry<K, V>> nodeConsumer) {
            this.traverseChildNodes(includeSelf, (index, child) -> nodeConsumer.accept((TreeEntry)child), null);
        }

        public boolean equalsKey(K key) {
            return ObjectUtil.equal(this.getKey(), key);
        }

        TreeEntryNode<K, V> traverseChildNodes(boolean includeCurrent, BiConsumer<Integer, TreeEntryNode<K, V>> consumer, BiPredicate<Integer, TreeEntryNode<K, V>> breakTraverse) {
            breakTraverse = ObjectUtil.defaultIfNull(breakTraverse, (i, n) -> false);
            LinkedList<List> keyNodeDeque = CollUtil.newLinkedList(CollUtil.newArrayList(this));
            boolean needProcess = includeCurrent;
            int index = includeCurrent ? 0 : 1;
            TreeEntryNode lastNode = null;
            while (!keyNodeDeque.isEmpty()) {
                List curr = (List)keyNodeDeque.removeFirst();
                ArrayList next = new ArrayList();
                for (TreeEntryNode node : curr) {
                    if (needProcess) {
                        consumer.accept(index, node);
                        if (breakTraverse.test(index, node)) {
                            return node;
                        }
                    } else {
                        needProcess = true;
                    }
                    CollUtil.addAll(next, node.children.values());
                }
                if (!next.isEmpty()) {
                    keyNodeDeque.addLast(next);
                }
                lastNode = (TreeEntryNode)CollUtil.getLast(next);
                ++index;
            }
            return lastNode;
        }

        void addChild(TreeEntryNode<K, V> child) {
            if (this.containsChild(child.key)) {
                return;
            }
            this.traverseParentNodes(true, s -> Assert.notEquals(s.key, treeEntryNode.key, "circular reference between [{}] and [{}]!", s.key, this.key), null);
            child.parent = this;
            child.traverseChildNodes(true, (i, c) -> {
                c.root = this.getRoot();
                c.weight = i + this.getWeight() + 1;
            }, null);
            this.children.put(child.key, child);
        }

        void removeDeclaredChild(K key) {
            TreeEntryNode child = this.children.get(key);
            if (ObjectUtil.isNull(child)) {
                return;
            }
            this.children.remove(key);
            child.parent = null;
            child.traverseChildNodes(true, (i, c) -> {
                c.root = child;
                c.weight = i;
            }, null);
        }

        @Override
        public TreeEntryNode<K, V> getChild(K key) {
            return this.traverseChildNodes(false, (i, c) -> {}, (i, c) -> c.equalsKey(key));
        }

        @Override
        public Map<K, TreeEntry<K, V>> getDeclaredChildren() {
            return new LinkedHashMap<K, TreeEntryNode<K, V>>(this.children);
        }

        @Override
        public Map<K, TreeEntry<K, V>> getChildren() {
            LinkedHashMap childrenMap = new LinkedHashMap();
            this.traverseChildNodes(false, (i, c) -> {
                TreeEntry cfr_ignored_0 = childrenMap.put(c.getKey(), c);
            }, null);
            return childrenMap;
        }

        void clear() {
            this.root = null;
            this.children.clear();
            this.parent = null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass().equals(o.getClass()) || ClassUtil.isAssignable(this.getClass(), o.getClass())) {
                return false;
            }
            TreeEntry treeEntry = (TreeEntry)o;
            return ObjectUtil.equals(this.getKey(), treeEntry.getKey());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getKey());
        }

        TreeEntryNode<K, V> copy(V value) {
            TreeEntryNode<K, V> copiedNode = new TreeEntryNode<K, V>(this.parent, this.key, ObjectUtil.defaultIfNull(value, this.value));
            copiedNode.children.putAll(this.children);
            return copiedNode;
        }
    }
}

