/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.stream;

import com.jxdinfo.hutool.core.lang.Opt;
import com.jxdinfo.hutool.core.stream.SimpleCollector;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class CollectorUtil {
    public static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    public static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    public static <T> Collector<T, ?, String> joining(CharSequence delimiter) {
        return CollectorUtil.joining(delimiter, Object::toString);
    }

    public static <T> Collector<T, ?, String> joining(CharSequence delimiter, Function<T, ? extends CharSequence> toStringFunc) {
        return CollectorUtil.joining(delimiter, "", "", toStringFunc);
    }

    public static <T> Collector<T, ?, String> joining(CharSequence delimiter, CharSequence prefix, CharSequence suffix, Function<T, ? extends CharSequence> toStringFunc) {
        return new SimpleCollector<Object, StringJoiner, String>(() -> new StringJoiner(delimiter, prefix, suffix), (joiner, ele) -> joiner.add((CharSequence)toStringFunc.apply(ele)), StringJoiner::merge, StringJoiner::toString, Collections.emptySet());
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingBy(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = Opt.ofNullable(t).map(classifier).orElse(null);
            Object container = m.computeIfAbsent(key, arg_0 -> CollectorUtil.lambda$null$245((Supplier)downstreamSupplier, arg_0));
            downstreamAccumulator.accept(container, t);
        };
        BinaryOperator<M> merger = CollectorUtil.mapMerger(downstream.combiner());
        Supplier<M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new SimpleCollector(mangledFactory, accumulator, merger, CH_ID);
        }
        Function downstreamFinisher = downstream.finisher();
        Function<Map, Map> finisher = intermediate -> {
            intermediate.replaceAll((k, v) -> downstreamFinisher.apply(v));
            Map castResult = intermediate;
            return castResult;
        };
        return new SimpleCollector<Object, Map, Map>(mangledFactory, accumulator, merger, finisher, CH_NOID);
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingBy(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return CollectorUtil.groupingBy(classifier, HashMap::new, downstream);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingBy(Function<? super T, ? extends K> classifier) {
        return CollectorUtil.groupingBy(classifier, Collectors.toList());
    }

    public static <T, K, U> Collector<T, ?, Map<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return CollectorUtil.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    public static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> map.put(Opt.ofNullable(element).map(keyMapper).get(), Opt.ofNullable(element).map(valueMapper).get());
        return new SimpleCollector(mapSupplier, accumulator, CollectorUtil.mapMerger(mergeFunction), CH_ID);
    }

    public static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    private static /* synthetic */ Object lambda$null$245(Supplier supplier, Object k) {
        return supplier.get();
    }
}

