/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hutool.core.bean;

import com.jxdinfo.hutool.core.bean.BeanDesc;
import com.jxdinfo.hutool.core.bean.BeanDescCache;
import com.jxdinfo.hutool.core.bean.BeanException;
import com.jxdinfo.hutool.core.bean.copier.BeanCopier;
import com.jxdinfo.hutool.core.bean.copier.CopyOptions;
import com.jxdinfo.hutool.core.collection.CollUtil;
import com.jxdinfo.hutool.core.lang.Editor;
import com.jxdinfo.hutool.core.map.MapUtil;
import com.jxdinfo.hutool.core.util.ArrayUtil;
import com.jxdinfo.hutool.core.util.ClassUtil;
import com.jxdinfo.hutool.core.util.ModifierUtil;
import com.jxdinfo.hutool.core.util.ObjectUtil;
import com.jxdinfo.hutool.core.util.ReflectUtil;
import com.jxdinfo.hutool.core.util.StrUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class BeanUtil {
    public static boolean isReadableBean(Class<?> clazz) {
        return BeanUtil.hasGetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean isBean(Class<?> clazz) {
        return BeanUtil.hasSetter(clazz) || BeanUtil.hasPublicField(clazz);
    }

    public static boolean hasSetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                if (method.getParameterCount() != 1 || !method.getName().startsWith("set")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasGetter(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Method method : clazz.getMethods()) {
                String name;
                if (method.getParameterCount() != 0 || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || "getClass".equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasPublicField(Class<?> clazz) {
        if (ClassUtil.isNormalClass(clazz)) {
            for (Field field : clazz.getFields()) {
                if (!ModifierUtil.isPublic(field) || ModifierUtil.isStatic(field)) continue;
                return true;
            }
        }
        return false;
    }

    public static BeanDesc getBeanDesc(Class<?> clazz) {
        return BeanDescCache.INSTANCE.getBeanDesc(clazz, () -> new BeanDesc(clazz));
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws BeanException {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new BeanException(e);
        }
        return ArrayUtil.filter(beanInfo.getPropertyDescriptors(), t -> !"class".equals(t.getName()));
    }

    public static Object getFieldValue(Object bean, String fieldNameOrIndex) {
        if (null == bean || null == fieldNameOrIndex) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(fieldNameOrIndex);
        }
        if (bean instanceof Collection) {
            try {
                return CollUtil.get((Collection)bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return CollUtil.map((Collection)bean, beanEle -> BeanUtil.getFieldValue(beanEle, fieldNameOrIndex), false);
            }
        }
        if (ArrayUtil.isArray(bean)) {
            try {
                return ArrayUtil.get(bean, Integer.parseInt(fieldNameOrIndex));
            }
            catch (NumberFormatException e) {
                return ArrayUtil.map(bean, Object.class, beanEle -> BeanUtil.getFieldValue(beanEle, fieldNameOrIndex));
            }
        }
        return ReflectUtil.getFieldValue(bean, fieldNameOrIndex);
    }

    public static <T> T fillBeanWithMap(Map<?, ?> map, T bean, CopyOptions copyOptions) {
        if (MapUtil.isEmpty(map)) {
            return bean;
        }
        BeanUtil.copyProperties(map, bean, copyOptions);
        return bean;
    }

    public static <T> T toBean(Object source, Class<T> clazz, CopyOptions options) {
        return (T)BeanUtil.toBean(source, () -> ReflectUtil.newInstanceIfPossible(clazz), options);
    }

    public static <T> T toBean(Object source, Supplier<T> targetSupplier, CopyOptions options) {
        if (null == source || null == targetSupplier) {
            return null;
        }
        T target = targetSupplier.get();
        BeanUtil.copyProperties(source, target, options);
        return target;
    }

    public static Map<String, Object> beanToMap(Object bean, String ... properties) {
        int mapSize = 16;
        Editor<String> keyEditor = null;
        if (ArrayUtil.isNotEmpty(properties)) {
            mapSize = properties.length;
            HashSet<String> propertiesSet = CollUtil.set(false, properties);
            keyEditor = property -> propertiesSet.contains(property) ? property : null;
        }
        return BeanUtil.beanToMap(bean, new LinkedHashMap<String, Object>(mapSize, 1.0f), false, keyEditor);
    }

    public static Map<String, Object> beanToMap(Object bean, Map<String, Object> targetMap, boolean ignoreNullValue, Editor<String> keyEditor) {
        if (null == bean) {
            return null;
        }
        return BeanCopier.create(bean, targetMap, CopyOptions.create().setIgnoreNullValue(ignoreNullValue).setFieldNameEditor(keyEditor)).copy();
    }

    public static void copyProperties(Object source, Object target, CopyOptions copyOptions) {
        if (null == source) {
            return;
        }
        BeanCopier.create(source, target, ObjectUtil.defaultIfNull(copyOptions, CopyOptions::create)).copy();
    }

    public static boolean isMatchName(Object bean, String beanClassName, boolean isSimple) {
        if (null == bean || StrUtil.isBlank(beanClassName)) {
            return false;
        }
        return ClassUtil.getClassName(bean, isSimple).equals(isSimple ? StrUtil.upperFirst(beanClassName) : beanClassName);
    }

    public static <T> T edit(T bean, Editor<Field> editor) {
        Field[] fields;
        if (bean == null) {
            return null;
        }
        for (Field field : fields = ReflectUtil.getFields(bean.getClass())) {
            if (ModifierUtil.isStatic(field)) continue;
            editor.edit(field);
        }
        return bean;
    }

    public static boolean isNotEmpty(Object bean, String ... ignoreFieldNames) {
        return !BeanUtil.isEmpty(bean, ignoreFieldNames);
    }

    public static boolean isEmpty(Object bean, String ... ignoreFieldNames) {
        if (null != bean) {
            for (Field field : ReflectUtil.getFields(bean.getClass())) {
                if (ModifierUtil.isStatic(field) || ArrayUtil.contains(ignoreFieldNames, field.getName()) || null == ReflectUtil.getFieldValue(bean, field)) continue;
                return false;
            }
        }
        return true;
    }
}

