/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.controller;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.common.util.SerializeUtils;
import com.jxdinfo.idp.extract.domain.dto.ExtractExportDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractGroupDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractNode;
import com.jxdinfo.idp.extract.domain.dto.ExtractOption;
import com.jxdinfo.idp.extract.domain.dto.ExtractTypeDtoOld;
import com.jxdinfo.idp.extract.domain.dto.GroupLevel;
import com.jxdinfo.idp.extract.domain.po.ExtractGroup;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.query.ExtractGroupQuery;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigDocMarkTemplate;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@RestController
@RequestMapping(value={"/extractCore"})
public class ExtractCoreController {
    @Autowired
    private IExtractCoreService service;

    @GetMapping(value={"/getGroupLevelTree"})
    public ApiResponse<List<GroupLevel>> getGroupLevelTree() {
        return ApiResponse.success(this.service.getGroupLevelTree());
    }

    public static String protected(String s) {
        int n = s.length();
        int n2 = n - 1;
        char[] cArray = new char[n];
        int n3 = 4 << 3 ^ 2;
        int cfr_ignored_0 = 3 ^ 5;
        int n4 = n2;
        int n5 = 4 << 4 ^ (2 ^ 5) << 1;
        while (n4 >= 0) {
            int n6 = n2--;
            cArray[n6] = (char)(s.charAt(n6) ^ n5);
            if (n2 < 0) break;
            int n7 = n2--;
            cArray[n7] = (char)(s.charAt(n7) ^ n3);
            n4 = n2;
        }
        return new String(cArray);
    }

    @GetMapping(value={"/deleteGroup"})
    public ApiResponse<Void> deleteGroup(@RequestParam(value="id") Long id) {
        try {
            this.service.deleteGroup(id);
        }
        catch (Exception a) {
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/extractOptions"})
    public ApiResponse<ExtractOption> extractOptions() {
        ExtractOption a;
        ExtractOption extractOption = a = new ExtractOption();
        ExtractCoreController extractCoreController = this;
        a.setExtractGroupLevel(extractCoreController.service.getGroupLevelTree());
        extractOption.setReturnTypes(extractCoreController.service.getReturnTypes());
        extractOption.setAfterHandlers(this.service.getAfterHandlerList());
        return ApiResponse.success((Object)extractOption);
    }

    @GetMapping(value={"/transTo"})
    public ApiResponse<ConfigDocMarkTemplate> transTo(@RequestParam(value="docId") String docId, @RequestParam(value="pageNum") Integer pageNum) {
        return ApiResponse.data((Object)this.service.pdfTransToImg(docId, pageNum));
    }

    @PostMapping(value={"/getItemList"})
    public ApiResponse<List<ExtractItemDto>> getItemList(@RequestBody ExtractItemQuery query) {
        return ApiResponse.success(this.service.getItemList(query));
    }

    @GetMapping(value={"/getDetail"})
    public ApiResponse<ExtractItemDto> getDetail(Long itemId) {
        return ApiResponse.success((Object)this.service.getItemDto(itemId));
    }

    @PostMapping(value={"/update"})
    public ApiResponse<Void> update(@RequestBody ExtractItem item) {
        this.service.update(item);
        return ApiResponse.success();
    }

    @PostMapping(value={"/getGroupTree"})
    public ApiResponse<List<ExtractNode>> getTree(@RequestBody ExtractGroupQuery query) {
        return ApiResponse.success(this.service.getTree(query));
    }

    @PostMapping(value={"/updateGroup"})
    public ApiResponse<Void> updateGroup(@RequestBody ExtractGroupDto dto) {
        try {
            this.service.updateGroup(dto);
        }
        catch (Exception a) {
            return ApiResponse.fail((String)a.getMessage());
        }
        return ApiResponse.success();
    }

    @GetMapping(value={"/getExtractTypeList"})
    public ApiResponse<List<ExtractTypeDtoOld>> getExtractTypeList() {
        return ApiResponse.success(this.service.getExtractTypeOldList());
    }

    @PostMapping(value={"/extractTest"})
    public ApiResponse<ExtractRecord> extractTest(@RequestBody ExtractItemDto dto) {
        return ApiResponse.success((Object)this.service.extractTest(dto));
    }

    @PostMapping(value={"/saveConfig"})
    public ApiResponse<Void> saveConfig(@RequestBody ExtractItemDto dto) {
        this.service.update(dto);
        return ApiResponse.success();
    }

    @PostMapping(value={"/recognitionMarkedImg"})
    public ApiResponse<String> recognitionMarkedImg(@RequestBody MultipartFile file) {
        return ApiResponse.data((Object)this.service.recognitionMarked(file));
    }

    @PostMapping(value={"/exportExtract"})
    public void exportExtract(@RequestBody List<Long> ids, HttpServletResponse response) {
        this.service.exportExtract(ids, response);
    }

    @PostMapping(value={"/test"})
    public List<ExtractRecord> test(@RequestParam(value="itemId") Long itemId, @RequestParam(value="file") MultipartFile file) throws IOException {
        return this.service.test(itemId, file);
    }

    @GetMapping(value={"/getTree"})
    public ApiResponse<List<ExtractGroupDto>> getTree() {
        return ApiResponse.success(this.service.getTree());
    }

    @PostMapping(value={"/batchDelete"})
    public ApiResponse<Void> batchDelete(@RequestBody List<Long> ids) {
        this.service.batchDelete(ids);
        return ApiResponse.success();
    }

    @PostMapping(value={"/insert"})
    public ApiResponse<Long> insert(@RequestBody ExtractItem item) {
        return ApiResponse.success((Object)this.service.insert(item));
    }

    @GetMapping(value={"/getReturnTypes"})
    public ApiResponse<List<Map<String, String>>> getReturnTypes() {
        return ApiResponse.success(this.service.getReturnTypes());
    }

    @GetMapping(value={"/itemStatistics"})
    public ApiResponse<Long> itemStatistics() {
        return ApiResponse.success((Object)this.service.itemStatistics());
    }

    @PostMapping(value={"/importExtract"})
    public ApiResponse<Void> importExtract(@RequestBody MultipartFile hussarFile) {
        try {
            byte[] a = hussarFile.getBytes();
            ExtractExportDto a2 = (ExtractExportDto)SerializeUtils.deserialize((byte[])a);
            this.service.importExtract(a2);
        }
        catch (ClassCastException a) {
            return ApiResponse.fail((int)10001, (String)ExtractCoreController.protected("\u639e\u53f4\u9837\u5bde\u512b\u5f20\u5e76\uff2e\u8bb9\u4e28\u4f6e\u63f2\u5398\u985b\u76ca\u5bde\u51b4\u65a5\u4eb8"));
        }
        catch (Exception a) {
            throw new BusinessException(ExtractCoreController.protected("\u63f2\u5398\u985b\u5bb2\u5147\u5f4c\u5e1ab\u5bde\u512b\u65a5\u682d\u89c1\u67de\u5913\u8d6b"), (Throwable)a);
        }
        return ApiResponse.success((String)ExtractCoreController.protected("\u5bde\u512b\u6232\u52d1"));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"/insertGroup"})
    public ApiResponse<ExtractGroup> insertGroup(@RequestBody ExtractGroupDto extractGroupDto) {
        void dto;
        return ApiResponse.success((Object)this.service.insertGroup((ExtractGroupDto)dto));
    }
}

