/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.chain.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.extract.chain.common.ChainUtils;
import com.jxdinfo.idp.extract.chain.common.ExtractorUtils;
import com.jxdinfo.idp.extract.chain.context.SimpleExtraceContext;
import com.jxdinfo.idp.extract.chain.dto.CurrentExtractChain;
import com.jxdinfo.idp.extract.chain.dto.ExtractChain;
import com.jxdinfo.idp.extract.chain.dto.ExtractLink;
import com.jxdinfo.idp.extract.chain.dto.ExtractNode;
import com.jxdinfo.idp.extract.chain.dto.ResultDataAttribute;
import com.jxdinfo.idp.extract.chain.dto.ResultDataCategory;
import com.jxdinfo.idp.extract.chain.service.IExtractChainService;
import com.jxdinfo.idp.extract.chain.service.IResultDataCategoryService;
import com.jxdinfo.idp.extract.chain.vo.ChainError;
import com.jxdinfo.idp.extract.container.ExtractorContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.params.common.ExtractorConfigUtils;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import com.jxdinfo.idp.flow.config.model.IdpFlowChain;
import com.jxdinfo.idp.flow.config.service.IdpFlowChainService;
import com.jxdinfo.idp.flow.domain.service.IdpFlowChainViewService;
import com.jxdinfo.idp.flow.domain.view.FlowChainView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
public class ExtractChainServiceImpl
implements IExtractChainService {
    @Resource
    private IdpFlowChainService idpFlowChainService;
    @Autowired
    private IExtractCoreService extractCoreService;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractChainServiceImpl.class);
    @Resource
    private IResultDataCategoryService resultDataCategoryService;
    @Resource
    private IdpFlowChainViewService idpFlowChainViewService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ExtractChain saveExtractChain(ExtractChain a) {
        try {
            FlowChainView flowChainView;
            ExtractChainServiceImpl a2;
            LOGGER.info(SimpleExtraceContext.public("\u4f88\u5b76\u6d38\u7a01\u5bc3\u4f44\u7c3bp!"), (Object)a);
            List<ChainError> list = a2.verify(a);
            if (CollectionUtils.isNotEmpty(list)) {
                Object[] objectArray = new Object[1];
                objectArray[0] = list.get(0).getMessage();
                throw new BusinessException(StrUtil.format((CharSequence)ExtractorUtils.implements("\u4e74\u80c9\u4fbb\u5b73\uff60\u5f72\u5227\u6d66\u7a4d\u5b53\u574a\u9536\u8b90\uff28\u0018S"), (Object[])objectArray));
            }
            ExtractChainServiceImpl extractChainServiceImpl = a2;
            extractChainServiceImpl.enum(a.getId(), a.getNodes());
            FlowChainView flowChainView2 = flowChainView = new FlowChainView();
            ExtractChain extractChain = a;
            FlowChainView flowChainView3 = flowChainView;
            ExtractChain extractChain2 = a;
            flowChainView.setId(extractChain2.getId());
            flowChainView3.setName(extractChain2.getName());
            flowChainView3.setView(a.getView());
            flowChainView.setEl(ChainUtils.toEL(extractChain));
            flowChainView2.setTags(ChainUtils.nodeToTagBatch(extractChain.getNodes()));
            flowChainView2.setLinks(ChainUtils.linkToFlowLinkBatch(a.getLinks()));
            extractChainServiceImpl.idpFlowChainViewService.saveOrUpdate(flowChainView);
            return extractChainServiceImpl.getExtractChain(a.getId());
        }
        catch (Exception exception) {
            LOGGER.error(new StringBuilder().insert(0, SimpleExtraceContext.public("\u4fa4\u5b52\u638d\u53c1\u94be\u593a\u8d79")).append(exception.getMessage()).toString(), (Throwable)exception);
            Object[] objectArray = new Object[1];
            objectArray[0] = exception.getMessage();
            throw new BusinessException(StrUtil.format((CharSequence)ExtractorUtils.implements("\u4fb7\u5b7f\u6396\u53dd\u949c\u591e\u8d5a\uff28\u0018S"), (Object[])objectArray));
        }
    }

    private static /* synthetic */ boolean super(CurrentExtractChain a, ExtractLink a2) {
        return StringUtils.isNotBlank((CharSequence)a2.getTargetId()) && StringUtils.isNotBlank((CharSequence)a2.getSourceId()) && Objects.equals(a2.getTargetId(), a.getCurrentNodeId());
    }

    private /* synthetic */ void enum(Long a, List<ExtractNode> a2) {
        a2 = a2.iterator();
        while (a2.hasNext()) {
            ExtractChainServiceImpl a3;
            ResultDataCategory resultDataCategory = ((ExtractNode)a2.next()).getCategory();
            if (resultDataCategory == null) continue;
            a3.resultDataCategoryService.saveResultDataCategory(a, resultDataCategory);
        }
    }

    private static /* synthetic */ boolean final(ExtractLink a, ExtractNode a2) {
        return Objects.equals(a2.getId(), a.getSourceId());
    }

    private /* synthetic */ List<ChainError> abstract(List<ExtractNode> a) {
        ArrayList<ChainError> arrayList = new ArrayList<ChainError>();
        a = a.iterator();
        while (a.hasNext()) {
            ExtractNode extractNode = (ExtractNode)a.next();
            try {
                ExtractChainServiceImpl a2;
                JSONObject jSONObject;
                String string;
                if (StringUtils.isNotEmpty((CharSequence)extractNode.getConfig()) && StringUtils.isNotEmpty((CharSequence)(string = (jSONObject = JSONObject.parseObject((String)extractNode.getConfig())).getString(SimpleExtraceContext.public("c9{9"))))) {
                    ExtractorConfigUtils.verifyValue(extractNode.getName(), ExtractorContainer.extractor(string), jSONObject);
                }
                arrayList.addAll(a2.case(extractNode));
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray = new Object[2];
                objectArray[0] = extractNode.getName();
                objectArray[1] = runtimeException.getMessage();
                arrayList.add(ChainError.error((String)extractNode.getId(), (String)StrUtil.format((CharSequence)ExtractorUtils.implements("=v\u53b3\u7530\u9566\u8bdd\u0018S"), (Object[])objectArray)));
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[1];
                objectArray[0] = extractNode.getName();
                arrayList.add(ChainError.error((String)extractNode.getId(), (String)StrUtil.format((CharSequence)SimpleExtraceContext.public("y(\u9163\u7f17\u53c8\u652d\u682b\u5f4f\u9512\u8bb3"), (Object[])objectArray)));
            }
        }
        return arrayList;
    }

    public ExtractChainServiceImpl() {
        ExtractChainServiceImpl a;
    }

    @Override
    public List<ExtractNode> getInputNode(Long a2) {
        ExtractChainServiceImpl a3;
        a2 = a3.idpFlowChainViewService.getTagByChainId((Long)((Object)a2));
        a2 = a2.stream().filter(a -> Objects.equals(a.getInputType(), ExtractorEnum.FILE_BYTES_INFO.getCode())).collect(Collectors.toList());
        return ChainUtils.tagToNodeBatch(a2);
    }

    @Override
    public ExtractChain getExtractChain(Long a) {
        ExtractChainServiceImpl a2;
        ExtractChain extractChain = new ExtractChain();
        extractChain.setMethod(Integer.valueOf(1));
        if ((IdpFlowChain)a2.idpFlowChainService.getById((Serializable)a) == null) {
            ExtractItemDto extractItemDto = a2.extractCoreService.getItemDto(a);
            if (extractItemDto == null) {
                throw new BusinessException(ExtractorUtils.implements("\u63db\u53b4\u6d6e\u7a74\u4e3f\u5b3b\u5706"));
            }
            ExtractChain extractChain2 = extractChain;
            ExtractChain extractChain3 = extractChain;
            extractChain.setId(a);
            extractChain3.setName(extractItemDto.getName());
            extractChain3.setMethod(extractItemDto.getMethod());
            extractChain2.setNodes(new ArrayList());
            extractChain.setLinks(new ArrayList());
            return extractChain2;
        }
        ExtractChainServiceImpl extractChainServiceImpl = a2;
        FlowChainView flowChainView = extractChainServiceImpl.idpFlowChainViewService.getById(a);
        ExtractChain extractChain4 = extractChain;
        FlowChainView flowChainView2 = flowChainView;
        ExtractChain extractChain5 = extractChain;
        extractChain5.setId(flowChainView.getId());
        extractChain5.setName(flowChainView.getName());
        extractChain.setView(flowChainView2.getView());
        extractChain4.setNodes(ChainUtils.tagToNodeBatch(flowChainView2.getTags()));
        extractChain4.setLinks(ChainUtils.flowLinkToLinkBatch(flowChainView.getLinks()));
        extractChainServiceImpl.long(a, extractChain4.getNodes());
        return extractChain;
    }

    private /* synthetic */ List<ChainError> case(ExtractNode a) {
        ResultDataCategory resultDataCategory = a.getCategory();
        ArrayList<ChainError> arrayList = new ArrayList<ChainError>();
        if (resultDataCategory == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a.getName();
            arrayList.add(ChainError.error(null, (String)StrUtil.format((CharSequence)SimpleExtraceContext.public("(\u007f\u76d1\u655e\u6317\u6a2b\u57d6\u4e1a\u80bd\u4e31\u7a26"), (Object[])objectArray)));
            return arrayList;
        }
        if (resultDataCategory.getId() == null) {
            Object[] objectArray = new Object[1];
            objectArray[0] = a.getName();
            arrayList.add(ChainError.error(null, (String)StrUtil.format((CharSequence)ExtractorUtils.implements("Z\u0017\u76a3\u6536\u6365\u6a43\u57a4\u4e72\u80cf\u4e59\u7a54"), (Object[])objectArray)));
        }
        if (CollectionUtils.isEmpty((Collection)resultDataCategory.getAttributeList())) {
            Object[] objectArray = new Object[2];
            objectArray[0] = a.getName();
            objectArray[1] = resultDataCategory.getName();
            arrayList.add(ChainError.error(null, (String)StrUtil.format((CharSequence)SimpleExtraceContext.public("=s\u6529\u636a\u6a72\u5789.S\u76fd\u5c54\u607a\u4e1a\u80bd\u4e31\u7a26"), (Object[])objectArray)));
            return arrayList;
        }
        for (ResultDataAttribute resultDataAttribute : resultDataCategory.getAttributeList()) {
            if (!Objects.equals(ExtractorUtils.implements("@\r@4n\u0005N\u000b[\f@"), a.getType())) continue;
            if (resultDataAttribute.getNodeId() == null) {
                Object[] objectArray = new Object[3];
                objectArray[0] = a.getName();
                objectArray[1] = resultDataCategory.getName();
                objectArray[2] = resultDataAttribute.getName();
                arrayList.add(ChainError.error(null, (String)StrUtil.format((CharSequence)SimpleExtraceContext.public("9l\u6536\u6360\u6a78\u578f(\u007f\u5c0b\u6009\u0002w\u6777\u901e\u62a9\u8289\u70e5"), (Object[])objectArray)));
            }
            if (!StringUtils.isBlank((CharSequence)resultDataAttribute.getNodeKey())) continue;
            Object[] objectArray = new Object[3];
            objectArray[0] = a.getName();
            objectArray[1] = resultDataCategory.getName();
            objectArray[2] = resultDataAttribute.getName();
            arrayList.add(ChainError.error(null, (String)StrUtil.format((CharSequence)ExtractorUtils.implements("K\u0004\u6544\u6308\u6a0a\u57e7Z\u0017\u5c79\u6061p\u001f\u6705\u9076\u62db\u5c3d\u6009"), (Object[])objectArray)));
        }
        return arrayList;
    }

    @Override
    public List<ChainError> verify(ExtractChain a) {
        ExtractChainServiceImpl a2;
        Object object;
        ArrayList<ChainError> arrayList = new ArrayList<ChainError>();
        List list = a.getNodes();
        if (CollectionUtils.isEmpty((Collection)list)) {
            arrayList.add(ChainError.error(null, (String)SimpleExtraceContext.public("\u6396\u53d8\u6d18\u7a0f\u6779\u8bbc\u7f3b\u7eea\u4e8f\uff06\u8baa\u62c1\u5125\u7ecf\u4eaa")));
        }
        ExtractNode extractNode = ChainUtils.getSingleNode(a);
        if (CollectionUtils.isEmpty((Collection)list)) {
            Object object2 = object = extractNode.iterator();
            while (object2.hasNext()) {
                extractNode = (ExtractNode)object.next();
                Object[] objectArray = new Object[1];
                objectArray[0] = extractNode.getName();
                arrayList.add(ChainError.error((String)extractNode.getId(), (String)StrUtil.format((CharSequence)ExtractorUtils.implements("\u7eef\u4e9aZ\u0017\u6c86\u674f\u4e05\u5114\u4ef9\u7ebb\u4ec4\u8fbd\u638b"), (Object[])objectArray)));
                object2 = object;
            }
        }
        if (CollectionUtils.isEmpty(object = ChainUtils.getFinalNode(a))) {
            arrayList.add(ChainError.error(null, (String)SimpleExtraceContext.public("\u65bd\u7ec4\u671f\u8289\u70e5")));
        }
        if (object.size() > 1) {
            Object[] objectArray = new Object[1];
            objectArray[0] = object.size();
            arrayList.add(ChainError.error(null, (String)StrUtil.format((CharSequence)ExtractorUtils.implements("\u4e6b\u516a\u8bd9\u51d6\u73ec\u590b\u4e40\u82a5\u70c4\u4f6c\u4e43\u7ee7\u6739\u82a9\u70d5\uff2d\u5f39\u526a\u7e95\u6754\u82e0\u7096\u4e45I\u001e\u4e04"), (Object[])objectArray)));
        }
        ArrayList<ChainError> arrayList2 = arrayList;
        arrayList2.addAll(a2.abstract(list));
        return arrayList2;
    }

    @Override
    public List<ResultDataCategory> getInputCategory(CurrentExtractChain a) {
        ArrayList<ResultDataCategory> arrayList = new ArrayList<ResultDataCategory>();
        if (a == null) {
            throw new BusinessException(SimpleExtraceContext.public("\u6d4b\u7a56\u6567\u632e\u7f31\u596d"));
        }
        if (StringUtils.isBlank((CharSequence)a.getCurrentNodeId())) {
            throw new BusinessException(ExtractorUtils.implements("\u5f39\u526a\u904f\u4e26\u82e0\u7096\u650f\u635c\u7f59\u591f"));
        }
        CurrentExtractChain currentExtractChain = a;
        List list = currentExtractChain.getNodes();
        List list22 = currentExtractChain.getLinks();
        if (CollectionUtils.isNotEmpty((Collection)list22)) {
            for (List list22 : list22.stream().filter(arg_0 -> ExtractChainServiceImpl.super((CurrentExtractChain)a, arg_0)).collect(Collectors.toList())) {
                list22 = list.stream().filter(arg_0 -> ExtractChainServiceImpl.final((ExtractLink)list22, arg_0)).findFirst().orElse(null);
                if (list22 == null || list22.getCategory() == null) continue;
                arrayList.add(list22.getCategory());
            }
        }
        return arrayList;
    }

    private /* synthetic */ void long(Long a, List<ExtractNode> a2) {
        Object object = a2 = a2.iterator();
        while (object.hasNext()) {
            ExtractNode extractNode = (ExtractNode)a2.next();
            ResultDataCategory resultDataCategory = extractNode.getCategory();
            if (resultDataCategory != null && resultDataCategory.getId() != null) {
                ExtractChainServiceImpl a3;
                resultDataCategory = a3.resultDataCategoryService.getResultDataCategory(a, resultDataCategory.getId());
            }
            extractNode.setCategory(resultDataCategory);
            object = a2;
        }
    }
}

