/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.word;

import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.config.word.WordChapterConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractor.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Word-\u7ae0\u8282\u63d0\u53d6", order=12)
public class WordChapterExtractor
extends AbstractDefaultExtractor<WordInfo, WordChapterInfo, WordChapterConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.WORD_CHAPTER;
    }

    public WordChapterExtractor() {
        WordChapterExtractor a;
    }

    @Override
    public List<WordChapterInfo> extract(List<WordInfo> a, WordChapterConfig a2) {
        ArrayList<WordChapterInfo> arrayList = new ArrayList<WordChapterInfo>();
        a = a.iterator();
        while (a.hasNext()) {
            for (WordChapterInfo wordChapterInfo : ((WordInfo)a.next()).getChapterInfos()) {
                if (!MatchTextUtil.isFuzzyMatched((String)a2.getChapterName(), (String)wordChapterInfo.getTitleName())) continue;
                arrayList.add(wordChapterInfo);
            }
        }
        return arrayList;
    }

    @Override
    public Class<?> outputClass() {
        return WordChapterInfo.class;
    }

    @Override
    public ExtractorCarrier<WordChapterInfo> outPut(List<WordInfo> a, WordChapterConfig a2) {
        WordChapterExtractor a3;
        ArrayList<WordChapterInfo> arrayList = new ArrayList<WordChapterInfo>();
        ArrayList<Location> arrayList2 = new ArrayList<Location>();
        a = a.iterator();
        while (a.hasNext()) {
            for (WordChapterInfo wordChapterInfo : ((WordInfo)a.next()).getChapterInfos()) {
                if (!MatchTextUtil.isFuzzyMatched((String)a2.getChapterName(), (String)wordChapterInfo.getTitleName())) continue;
                arrayList2.add(new Location(wordChapterInfo.getTitleName()));
                arrayList.add(wordChapterInfo);
            }
        }
        return a3.carrier(arrayList, arrayList2);
    }
}

