/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.chain.controller;

import com.jxdinfo.idp.common.response.ApiResponse;
import com.jxdinfo.idp.extract.chain.container.ChainComponentContainer;
import com.jxdinfo.idp.extract.chain.context.SimpleExtraceContext;
import com.jxdinfo.idp.extract.chain.dto.CurrentExtractChain;
import com.jxdinfo.idp.extract.chain.dto.ExtractChain;
import com.jxdinfo.idp.extract.chain.dto.ResultDataCategory;
import com.jxdinfo.idp.extract.chain.entity.ComponentEntity;
import com.jxdinfo.idp.extract.chain.service.IExtractChainService;
import com.jxdinfo.idp.extract.chain.vo.ChainError;
import com.jxdinfo.idp.flow.engine.IdpFlowExecutor;
import com.jxdinfo.idp.flow.engine.model.IdpFlowInstance;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ibatis.annotations.Param;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/extract/chain"})
public class ExtractChainController {
    @Resource
    private IdpFlowExecutor idpFlowExecutor;
    @Resource
    private IExtractChainService extractChainService;

    @PostMapping(value={"verify"})
    public ApiResponse<List<ChainError>> verify(@RequestBody ExtractChain extractChain) {
        return ApiResponse.success(this.extractChainService.verify(extractChain));
    }

    /*
     * WARNING - void declaration
     */
    @PostMapping(value={"getInputCategory"})
    public ApiResponse<List<ResultDataCategory>> getInputCategory(@RequestBody CurrentExtractChain currentExtractChain) {
        void currentExtractChain2;
        return ApiResponse.success(this.extractChainService.getInputCategory((CurrentExtractChain)currentExtractChain2));
    }

    @GetMapping(value={"/getExtractChain"})
    public ApiResponse<ExtractChain> getExtractChain(@Param(value="id") Long id) {
        return ApiResponse.success((Object)this.extractChainService.getExtractChain(id));
    }

    @GetMapping(value={"/execute"})
    public ApiResponse<IdpFlowInstance> execute(@RequestParam Long id) {
        return ApiResponse.success((Object)this.idpFlowExecutor.execute(id, (Object)new SimpleExtraceContext()));
    }

    @PostMapping(value={"/saveExtractChain"})
    public ApiResponse<ExtractChain> saveExtractChain(@RequestBody ExtractChain extractChain) {
        return ApiResponse.success((Object)this.extractChainService.saveExtractChain(extractChain));
    }

    @GetMapping(value={"/getComponents"})
    public ApiResponse<List<ComponentEntity>> getComponents() {
        return ApiResponse.success((Object)ChainComponentContainer.getComponentList());
    }
}

