/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.thirdpartapi;

import com.jxdinfo.idp.common.enums.dto.OcrGenericRequest;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.extract.domain.extractor.ocrconfigxtract.OcrPageResponse;
import com.jxdinfo.idp.extract.domain.restTemplate.response.OcrApiResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class OcrGenericText {
    private static final Logger log = LoggerFactory.getLogger(OcrGenericText.class);
    @Value(value="${rmi.ocrGenericText.url}")
    private String URL;
    @Value(value="${rmi.ocrGenericText.api.extract}")
    private String extract;
    @Autowired
    private RestTemplate restTemplate;

    public OcrApiResponse<List<OcrPageResponse>> getOcr(final OcrGenericRequest ocrGenericRequest) {
        try {
            LinkedMultiValueMap body = new LinkedMultiValueMap();
            body.add((Object)"file", (Object)new ByteArrayResource(ocrGenericRequest.getFile().getBytes()){

                public String getFilename() {
                    return ocrGenericRequest.getFile().getOriginalFilename();
                }
            });
            body.add((Object)"text", (Object)ocrGenericRequest.getText());
            body.add((Object)"table", (Object)ocrGenericRequest.getTable());
            body.add((Object)"objdet", (Object)ocrGenericRequest.getObjdet());
            body.add((Object)"seal_rec", (Object)ocrGenericRequest.getSeal_rec());
            body.add((Object)"file_type", (Object)ocrGenericRequest.getFile_type());
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.MULTIPART_FORM_DATA);
            ResponseEntity response = this.restTemplate.exchange(this.URL + this.extract, HttpMethod.POST, new HttpEntity((Object)body, (MultiValueMap)headers), (ParameterizedTypeReference)new ParameterizedTypeReference<OcrApiResponse<List<OcrPageResponse>>>(){}, new Object[0]);
            return (OcrApiResponse)response.getBody();
        }
        catch (Exception e) {
            log.error("ocr \u901a\u7528\u6587\u672c\u8bc6\u522b\u670d\u52a1OcrGenericText-getOcr\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            throw new BusinessException("ocr \u901a\u7528\u6587\u672c\u8bc6\u522b\u670d\u52a1\u5931\u8d25:" + e.getMessage());
        }
    }
}

