/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.interf.impl;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.chain.context.SimpleExtraceContext;
import com.jxdinfo.idp.extract.container.ExtractorOldContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainNodeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.extractorOld.IExtractor;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import com.jxdinfo.idp.extract.service.IExtractItemService;
import com.jxdinfo.idp.flow.engine.IdpFlowExecutor;
import com.jxdinfo.idp.flow.engine.model.IdpFlowInstance;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtractCoreImpl
implements IExtractCore {
    private static final Logger log = LoggerFactory.getLogger(ExtractCoreImpl.class);
    @Autowired
    private IExtractItemService itemService;
    @Autowired
    private IExtractCoreService extractCoreService;
    @Resource
    private IdpFlowExecutor idpFlowExecutor;

    public List<ExtractRecord> execute(List<ExtractItemDto> itemDtoList, FileBytesInfo bytesInfo) {
        log.info("\u3010{}\u3011\u5f00\u59cb\u6267\u884c\u63d0\u53d6", (Object)bytesInfo.getFileName());
        long startTime = System.nanoTime();
        IExtractor extractor = ExtractorOldContainer.get("fileExtractor");
        List<ExtractRecord> records = extractor.execute(itemDtoList, bytesInfo);
        records.forEach(record -> log.info("\u3010{}\u3011\u63d0\u53d6\u9879\u7684\u63d0\u53d6\u7ed3\u679c\uff1a{}", (Object)record.getItemName(), (Object)record.getResult()));
        log.info("\u3010{}\u3011\u63d0\u53d6\u5b8c\u6210\uff0c\u8017\u65f6\uff1a{}ms", (Object)bytesInfo.getFileName(), (Object)((System.nanoTime() - startTime) / 1000000L));
        return records;
    }

    public List<ExtractRecord> execute(List<ExtractChainItemDto> itemDtoList, List<ExtractChainNodeDto> nodeDtoList) {
        ArrayList<ExtractRecord> records = new ArrayList<ExtractRecord>();
        for (ExtractChainItemDto extractChainItemDto : itemDtoList) {
            SimpleExtraceContext simpleExtraceContext = new SimpleExtraceContext();
            for (ExtractChainNodeDto extractChainNodeDto : nodeDtoList) {
                simpleExtraceContext.getNodeMap().put(extractChainNodeDto.getId(), extractChainNodeDto);
            }
            IdpFlowInstance instance = this.idpFlowExecutor.execute(extractChainItemDto.getId(), (Object)simpleExtraceContext);
            ExtractRecord record = new ExtractRecord();
            record.setExtractItemId(extractChainItemDto.getId());
            record.setResultObject((Object)instance.getResult());
            records.add(record);
        }
        return records;
    }

    public List<ExtractItemDto> getExtractItemList(ExtractItemQuery queryVo) {
        return this.itemService.getDtoList(queryVo);
    }

    public List<ExtractItemDto> getExtractItemsByIds(List<Long> ids) {
        ExtractItemQuery query = new ExtractItemQuery();
        query.setIds(ids);
        return this.getExtractItemList(query);
    }

    public ExtractItem findById(long itemId) {
        return (ExtractItem)this.itemService.getById(Long.valueOf(itemId));
    }

    public long save(ExtractItem extractItem) {
        return this.extractCoreService.insert(extractItem);
    }
}

