/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.word;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordParagraphInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordRowInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.word.WordBasicTypeConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class WordBasicTypeExtractor
extends AbstractChannelExtractor<WordInfo, WordBasicTypeConfig> {
    private static final Logger log = LoggerFactory.getLogger(WordBasicTypeExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.WORD_BASIC_TYPE.getCode(), GroupLevel3Enum.WORD_BASIC_TYPE.getName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(WordInfo wordInfo, WordBasicTypeConfig config) {
    }

    @Override
    public List<Object> extract(WordInfo wordInfo, WordBasicTypeConfig config) {
        ArrayList<Object> result = new ArrayList<Object>();
        if ("para".equals(config.getSource())) {
            List paraInfos = wordInfo.getParaInfos();
            if (StringUtils.isEmpty((Object)config.getRegex())) {
                config.setRegex("(.*)");
            }
            for (WordParagraphInfo paraInfo : paraInfos) {
                result.addAll(this.match(config.getRegex(), paraInfo.getText()));
            }
        } else if ("table".equals(config.getSource())) {
            List tableInfos = wordInfo.getTableInfos();
            List<Object> objects = this.getFromAllTable(tableInfos, config.getXOffset(), config.getYOffset(), config.getBasicText(), config.getRegex());
            result.addAll(objects);
        }
        return result;
    }

    private List<Object> getFromAllTable(List<WordTableInfo> tableInfos, int xOffset, int yOffset, String basicText, String regex) {
        List xList;
        LinkedHashMap<Integer, Map> tableCoordinateMap = new LinkedHashMap<Integer, Map>();
        ArrayList<Object> result = new ArrayList<Object>();
        if (CollUtil.isEmpty(tableInfos)) {
            return new ArrayList<Object>();
        }
        for (int i = 0; i < tableInfos.size(); ++i) {
            WordTableInfo tableInfo = tableInfos.get(i);
            List rows = tableInfo.getRows();
            for (WordRowInfo row : rows) {
                List cells = row.getCells();
                for (WordCellInfo cell : cells) {
                    if (!MatchTextUtil.isFuzzyMatched((String)basicText, (String)cell.getText())) continue;
                    Map coordinateMap = tableCoordinateMap.computeIfAbsent(i, k -> new LinkedHashMap());
                    xList = coordinateMap.computeIfAbsent(row.getIndex(), k -> new ArrayList());
                    xList.add(cell.getIndex());
                }
            }
        }
        for (Map.Entry entry : tableCoordinateMap.entrySet()) {
            Integer tableIndex = (Integer)entry.getKey();
            Map coordinateMap = (Map)entry.getValue();
            for (Map.Entry coordinateEntry : coordinateMap.entrySet()) {
                int y = (Integer)coordinateEntry.getKey();
                int targetY = y + yOffset;
                xList = (List)coordinateEntry.getValue();
                for (Integer x : xList) {
                    int targetX = x + xOffset;
                    try {
                        WordCellInfo cellInfo = (WordCellInfo)((WordRowInfo)tableInfos.get(tableIndex).getRows().get(targetY)).getCells().get(targetX);
                        if (StringUtils.isEmpty((Object)regex)) {
                            result.add(cellInfo.getText());
                            continue;
                        }
                        result.addAll(this.match(regex, cellInfo.getText()));
                    }
                    catch (Exception e) {
                        log.error("\u672a\u5bfb\u627e\u5230\u76ee\u6807\u5355\u5143\u683c");
                    }
                }
            }
        }
        return result;
    }
}

