/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Cell;
import com.jxdinfo.idp.common.entity.util.docparse.pdf.Table;
import com.jxdinfo.idp.common.pdfparser.core.PdfParser;
import com.jxdinfo.idp.common.pdfparser.pojo.ContentPojo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.ResolvablePDFTableConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.springframework.stereotype.Service;

@Service
public class ResolvablePDFTableExtractor
extends AbstractChannelExtractor<FileBytesInfo, ResolvablePDFTableConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.RESOLVABLE_PDF_TABLE.getCode(), "PDF\u8868\u683c\u63d0\u53d6\u5668\uff08java\uff09");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(FileBytesInfo contentPojo, ResolvablePDFTableConfig config) {
    }

    @Override
    public List<Object> extract(FileBytesInfo fileBytesInfo, ResolvablePDFTableConfig config) {
        ContentPojo pojo = null;
        try {
            ReadPdfUtil.removeWatermark((FileBytesInfo)fileBytesInfo, (String[])new String[0]);
            PDDocument document = PDDocument.load((byte[])fileBytesInfo.getFileBytes());
            pojo = PdfParser.parsingUnTaggedPdfWithTableDetection((PDDocument)document, (boolean)true);
        }
        catch (IOException e) {
            return new ArrayList<Object>();
        }
        List tables = pojo.getOutList().stream().filter(item -> "table".equals(item.getElementType())).collect(Collectors.toList());
        ArrayList<Object> result = new ArrayList<Object>();
        for (String cellKey : config.getCellKey()) {
            List<String> regexes = Arrays.asList(cellKey.split(";"));
            block3: for (ContentPojo.contentElement table : tables) {
                List cells = table.getCells();
                if (CollUtil.isEmpty((Collection)cells)) continue;
                int cellIndex = 0;
                ContentPojo.contentElement.InnerCell cell = (ContentPojo.contentElement.InnerCell)cells.get(cellIndex);
                for (int i = 0; i < regexes.size(); ++i) {
                    String regex = regexes.get(i);
                    while (!MatchTextUtil.isMatch((String)regex, (String)cell.getText()).booleanValue()) {
                        if (++cellIndex >= cells.size()) continue block3;
                        cell = (ContentPojo.contentElement.InnerCell)cells.get(cellIndex);
                    }
                    if (i != regexes.size() - 1) continue;
                    result.add(this.tableConvert(cells));
                    return result;
                }
            }
        }
        return result;
    }

    private Table tableConvert(List<ContentPojo.contentElement.InnerCell> cells) {
        Table table = new Table();
        ArrayList<Cell> targetCells = new ArrayList<Cell>();
        table.setCells(targetCells);
        for (ContentPojo.contentElement.InnerCell cell : cells) {
            Cell targetCell = new Cell();
            targetCell.setCol(cell.getCol_index());
            targetCell.setRow(cell.getRow_index());
            targetCell.setText(cell.getText() == null ? "" : cell.getText());
            targetCells.add(targetCell);
        }
        return table;
    }

    @Override
    public Object after(List<Object> list, ResolvablePDFTableConfig config) {
        return list;
    }
}

