/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.excel;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.excel.ExcelBasicTypeConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ExcelBasicTypeExtractor
extends AbstractChannelExtractor<ExcelInfo, ExcelBasicTypeConfig> {
    private static final Logger log = LoggerFactory.getLogger(ExcelBasicTypeExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.EXCEL_BASIC_TYPE.getCode(), GroupLevel3Enum.EXCEL_BASIC_TYPE.getName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(ExcelInfo excelInfo, ExcelBasicTypeConfig excelBasicTypeConfig) {
    }

    @Override
    public List<Object> extract(ExcelInfo excelInfo, ExcelBasicTypeConfig config) {
        List sheetInfos = excelInfo.getSheetInfos();
        if (config.getSheetName() == null && config.getSheetIndex() == null) {
            return this.extractFromSheets(sheetInfos, config);
        }
        List<ExcelSheetInfo> targetSheetInfos = sheetInfos.stream().filter(sheetInfo -> MatchTextUtil.isFuzzyMatched((String)config.getSheetName(), (String)sheetInfo.getName())).collect(Collectors.toList());
        return this.extractFromSheets(targetSheetInfos, config);
    }

    private List<Object> extractFromSheets(List<ExcelSheetInfo> sheetInfos, ExcelBasicTypeConfig config) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (StringUtils.isEmpty((Object)config.getBasicText())) {
            return result;
        }
        for (ExcelSheetInfo sheetInfo : sheetInfos) {
            ExcelCellInfo[][] cellArray2D = sheetInfo.getCellArray2D();
            for (int y = 0; y < cellArray2D.length; ++y) {
                ExcelCellInfo[] cellArray = cellArray2D[y];
                if (cellArray == null) continue;
                for (int x = 0; x < cellArray.length; ++x) {
                    ExcelCellInfo cellInfo = cellArray[x];
                    if (cellInfo == null || cellInfo.getValue() == null || !MatchTextUtil.isFuzzyMatched((String)config.getBasicText(), (String)cellInfo.getValueStr())) continue;
                    try {
                        ExcelCellInfo target = cellArray2D[y + config.getYOffset()][x + config.getXOffset()];
                        result.addAll(this.match(config.getRegex(), target.getValue()));
                        continue;
                    }
                    catch (Exception e) {
                        log.error("\u6570\u7ec4\u4e0b\u6807\u8d8a\u754c\uff01");
                    }
                }
            }
        }
        return result;
    }
}

