/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTextRGConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf.dto.RGTableCellDto;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="analysePDFTextJSONRGExtractor")
public class AnalysePDFTextJSONRGExtractor
extends AbstractChannelExtractor<FileBytesInfo, AnalysePDFTextRGConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TEXT_RG_JSON.getCode(), "\u5408\u540c\u660e\u7ec6\u89e3\u6790json");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(FileBytesInfo fileBytesInfo, AnalysePDFTextRGConfig wordTableConfig) {
    }

    @Override
    public List<Object> extract(FileBytesInfo fileBytesInfo, AnalysePDFTextRGConfig config) {
        JSONObject structureInfo = ReadPdfUtil.getPDFTable((FileBytesInfo)fileBytesInfo);
        ArrayList<Object> result = new ArrayList<Object>();
        JSONArray textBlocks = structureInfo.getJSONArray("textBlocks");
        int k = 0;
        if (!StringUtils.isEmpty((Object)config.getKeyword()) && (k = this.findIndex(textBlocks, config.getKeyword())) == -1) {
            return result;
        }
        int s = 0;
        boolean start = false;
        int rowIndex = 0;
        boolean tablekey = ObjectUtil.isNotNull((Object)config.getTableKey());
        int j = textBlocks.size();
        for (int i = k; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (MatchTextUtil.isMatch((String)config.getStopKey(), (String)textBlock.getString("text")).booleanValue()) {
                return result;
            }
            List<RGTableCellDto> jsonObject = this.textToJSONObject(textBlock.getString("text"), rowIndex);
            if (jsonObject.isEmpty() && start) {
                if (++s < config.getStopLine()) continue;
                return result;
            }
            if (tablekey) {
                boolean isKey = true;
                int m = config.getTableKey().size();
                block1: for (int l = 0; l < m; ++l) {
                    String vv = (String)config.getTableKey().get(l);
                    for (RGTableCellDto rgTableCellDto : jsonObject) {
                        if (MatchTextUtil.match((String)rgTableCellDto.getContent(), (String)vv).isEmpty()) continue;
                        isKey = false;
                        if (!start) continue;
                        if (++s < config.getStopLine()) continue block1;
                        return result;
                    }
                }
                if (isKey) continue;
            }
            result.addAll(jsonObject);
            start = true;
        }
        return result;
    }

    @Override
    public Object after(List<Object> list, AnalysePDFTextRGConfig config) {
        return list;
    }

    private List<RGTableCellDto> textToJSONObject(String text, int rowIndex) {
        String[] chinese;
        ArrayList<RGTableCellDto> row = new ArrayList<RGTableCellDto>();
        String[] english = text.split(":");
        if (english.length + (chinese = text.split("\uff1a")).length == 2) {
            return row;
        }
        String[] texts = english.length > chinese.length ? english : chinese;
        int j = texts.length - 1;
        for (int i = 1; i < j; ++i) {
            RGTableCellDto dto = new RGTableCellDto();
            String t = texts[i];
            String v = t.substring(0, t.trim().lastIndexOf(" ")).trim();
            dto.setContent(v);
            dto.setRowIndex(rowIndex);
            dto.setColumnIndex(i - 1);
            row.add(dto);
        }
        return row;
    }

    private int findIndex(JSONArray textBlocks, String keyword) {
        int j = textBlocks.size();
        for (int i = 0; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!MatchTextUtil.isMatch((String)keyword, (String)textBlock.getString("text")).booleanValue()) continue;
            return i + 1;
        }
        return -1;
    }
}

