/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.idp.common.base.dto.AuditInfoDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractGroupRel;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.mapper.ExtractItemMapper;
import com.jxdinfo.idp.extract.service.IExtractGroupRelService;
import com.jxdinfo.idp.extract.service.IExtractItemService;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ExtractItemServiceImpl
extends ServiceImpl<ExtractItemMapper, ExtractItem>
implements IExtractItemService {
    @Autowired
    private ExtractItemMapper mapper;
    @Autowired
    private IExtractGroupRelService relService;

    @Override
    public Page<ExtractItemDto> getDtoPageList(ExtractItemQuery queryVo) {
        return this.mapper.getDtoPageList((Page<ExtractItemDto>)queryVo.getPage(ExtractItemDto.class), queryVo);
    }

    @Override
    public List<ExtractItem> getList(ExtractItemQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        List<ExtractGroupRel> rels = this.relService.getByPid(query.getGroupId());
        if (!StringUtils.isEmpty((Object)query.getGroupId())) {
            List groupIds = rels.stream().map(ExtractGroupRel::getCid).collect(Collectors.toList());
            groupIds.add(query.getGroupId());
            wrapper.in(ExtractItem::getGroupId, groupIds);
        }
        wrapper.like(!StringUtils.isEmpty((Object)query.getName()), ExtractItem::getName, (Object)query.getName());
        wrapper.eq(!StringUtils.isEmpty((Object)query.getReturnType()), ExtractItem::getReturnType, (Object)query.getReturnType());
        wrapper.orderByDesc(AuditInfoDto::getCreateTime);
        return this.list((Wrapper)wrapper);
    }

    @Override
    public List<ExtractItemDto> getDtoList(ExtractItemQuery queryVo) {
        return this.mapper.getDtoList(queryVo);
    }

    @Override
    public ExtractItem findById(long id) {
        return (ExtractItem)this.mapper.selectById(Long.valueOf(id));
    }

    @Override
    public void delete(List<Long> groupIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ExtractItem::getGroupId, groupIds);
        this.remove((Wrapper)wrapper);
    }
}

