/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrTextConfig;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractConfigEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor.AbstractItemExtractor;
import com.jxdinfo.idp.extract.thirdpartapi.OcrConfigServe;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OcrItemExtractor
extends AbstractItemExtractor<FileBytesInfo, FileBytesInfo> {
    private static final Logger log = LoggerFactory.getLogger(OcrItemExtractor.class);
    private static JSONObject config = new JSONObject();
    private static JSONObject rules = new JSONObject();
    @Autowired
    private OcrConfigServe ocrConfigServe;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.OCR.getImplCode(), ItemExtractorEnum.OCR.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public FileBytesInfo before(FileBytesInfo bytesInfo) {
        return bytesInfo;
    }

    @Override
    public List<ExtractRecord> extract(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        ReadPdfUtil.removeWatermark((FileBytesInfo)bytesInfo, (String[])new String[0]);
        ArrayList<OcrTextConfig> texts = new ArrayList<OcrTextConfig>();
        ArrayList<JSONObject> tables = new ArrayList<JSONObject>();
        ArrayList<JSONObject> seals = new ArrayList<JSONObject>();
        ArrayList<JSONObject> signs = new ArrayList<JSONObject>();
        HashMap<String, List<String>> regexMap = new HashMap<String, List<String>>();
        for (ExtractItemDto dto : itemDtoList) {
            List relevancyList = dto.getTypeInfoList();
            List ocrTypeInfos = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.OCR.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(ocrTypeInfos)) continue;
            for (ExtractTypeInfo info : ocrTypeInfos) {
                Object ocrJson;
                Map extractConfig;
                if (GroupLevel3Enum.OCR_SIMPLE.getCode().equals(info.getExtractType())) {
                    OcrTextConfig text = info.getExtractConfig() != null ? (OcrTextConfig)JSONObject.parseObject((String)JSON.toJSONString((Object)info.getExtractConfig()), OcrTextConfig.class) : (OcrTextConfig)info.extractConfig(ExtractConfigEnum.extractConfig((String)info.getExtractType()));
                    text.setId(String.valueOf(info.getId()));
                    text.setKey(info.getName() + info.getId());
                    if (StringUtils.isEmpty((String)text.getIndex_trend())) {
                        text.setIndex_trend("left");
                    }
                    List pattern = text.getPattern();
                    text.setPattern(new ArrayList<String>(Collections.singletonList("(.*)")));
                    if (!(CollUtil.isEmpty((Collection)pattern) || pattern.size() == 1 && StringUtils.isEmpty((String)((String)pattern.get(0))))) {
                        regexMap.put(info.getName() + info.getId(), pattern);
                    }
                    text.setElement_name(info.getName() + info.getId());
                    texts.add(text);
                    continue;
                }
                if (GroupLevel3Enum.OCR_SEAL.getCode().equals(info.getExtractType())) {
                    info.extractConfig();
                    extractConfig = info.getExtractConfig();
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        JSONObject seal = JSON.parseObject((String)ocrJson.toString());
                        seal.put("element_name", (Object)(info.getName() + info.getId()));
                        seals.add(seal);
                    }
                    catch (Exception e) {
                        log.error("\u5370\u7ae0\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                    }
                    continue;
                }
                if (GroupLevel3Enum.OCR_SIGN.getCode().equals(info.getExtractType())) {
                    info.extractConfig();
                    extractConfig = info.getExtractConfig();
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        String str = ocrJson.toString();
                        JSONObject sign = JSON.parseObject((String)str);
                        sign.put("element_name", (Object)(info.getName() + info.getId()));
                        signs.add(sign);
                        signs.add(JSON.parseObject((String)ocrJson.toString()));
                    }
                    catch (Exception e) {
                        log.error("\u7b7e\u5b57\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                    }
                    continue;
                }
                if (!GroupLevel3Enum.OCR_TABLE.getCode().equals(info.getExtractType())) continue;
                info.extractConfig();
                extractConfig = info.getExtractConfig();
                try {
                    JSONObject table = JSON.parseObject((String)JSON.toJSONString((Object)extractConfig));
                    table.put("element_name", (Object)(info.getName() + info.getId()));
                    tables.add(table);
                }
                catch (Exception e) {
                    log.error("\u8868\u683c\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                }
            }
        }
        ArrayList<ExtractRecord> result = new ArrayList<ExtractRecord>();
        if (CollUtil.isNotEmpty(texts)) {
            rules.put("text", texts);
        }
        if (CollUtil.isNotEmpty(seals)) {
            rules.put("seal", seals);
        }
        if (CollUtil.isNotEmpty(tables)) {
            rules.put("table", tables);
        }
        if (CollUtil.isNotEmpty(signs)) {
            rules.put("sign", signs);
        }
        log.info("OCR>>> \u3010{}\u3011\u63d0\u53d6\u5f00\u59cb\u6267\u884c\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a\u3010{}\u3011", (Object)bytesInfo.getFileName(), (Object)LocalDateTime.now());
        ConfigOcrResponse ocr = null;
        try {
            ocr = this.ocrConfigServe.ocr((Map)config, bytesInfo.getFileFormat(), bytesInfo.getFileBytes());
        }
        catch (Exception e) {
            log.error("OCR\u670d\u52a1\u5f02\u5e38", (Throwable)e);
        }
        log.info("OCR\u7b97\u6cd5\u63d0\u53d6\u7ed3\u675f\uff0c\u63d0\u53d6\u7ed3\u679c\uff1a{}", (Object)ocr);
        for (ExtractItemDto dto : itemDtoList) {
            ExtractRecord record = this.getExtractRecord(dto, ocr, regexMap);
            log.info("OCR>>> \u63d0\u53d6\u9879\u3010{}\u3011\u63d0\u53d6\u7ed3\u679c\uff1a{}", (Object)dto.getName(), (Object)record.getResult());
            result.add(record);
        }
        log.info("OCR>>> \u3010{}\u3011\u63d0\u53d6\u7ed3\u675f\u6267\u884c\uff0c\u7ed3\u675f\u65f6\u95f4\uff1a\u3010{}\u3011", (Object)bytesInfo.getFileName(), (Object)LocalDateTime.now());
        return result;
    }

    private ExtractRecord getExtractRecord(ExtractItemDto dto, ConfigOcrResponse ocr, Map<String, List<String>> regexMap) {
        ExtractRecord record = new ExtractRecord();
        record.setExtractItemId(dto.getId());
        record.setItemName(dto.getName());
        if (ocr == null) {
            record.setResult("\u62b1\u6b49\uff0c\u8bf7\u68c0\u67e5OCR\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            record.setResultObject((Object)"\u62b1\u6b49\uff0c\u8bf7\u68c0\u67e5OCR\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
        } else {
            List relevancyList = dto.getTypeInfoList();
            relevancyList.forEach(info -> {
                if (!StringUtils.isEmpty((String)record.getResult()) && !"\"\"".equals(record.getResult())) {
                    return;
                }
                Object ocrResult = ocr.get(info.getName() + info.getId());
                List regexes = (List)regexMap.get(info.getName() + info.getId());
                if (CollUtil.isNotEmpty((Collection)regexes)) {
                    for (String regex : regexes) {
                        if (ocrResult == null || StringUtils.isEmpty((String)regex) || !(ocrResult instanceof String)) continue;
                        List matchedList = MatchTextUtil.Match((String)regex, (Object)ocrResult);
                        StringBuilder builder = new StringBuilder();
                        for (int i = 0; i < matchedList.size(); ++i) {
                            builder.append(matchedList.get(i));
                            if (i != matchedList.size() - 1) continue;
                            builder.append(" ");
                        }
                        builder = new StringBuilder(builder.toString().trim());
                        ocrResult = builder.toString();
                        break;
                    }
                }
                if (ocrResult != null) {
                    record.setResult(JSON.toJSONString((Object)ocrResult));
                }
                record.setResultObject(ocrResult);
            });
        }
        return record;
    }

    static {
        config.put("rules", (Object)rules);
        JSONObject globalParam = new JSONObject();
        config.put("global_param", (Object)globalParam);
        globalParam.put("pdf_num", (Object)99);
        globalParam.put("continuous_page_number", (Object)false);
        globalParam.put("recognitionRange", (Object)"0");
        JSONObject objectSetting = new JSONObject();
        globalParam.put("object_setting", (Object)objectSetting);
        objectSetting.put("seal_det", (Object)true);
        objectSetting.put("seal_det_thresh", (Object)0.5);
        objectSetting.put("sign_det", (Object)true);
        objectSetting.put("sign_det_thresh", (Object)0.5);
        objectSetting.put("writedate_det", (Object)false);
        objectSetting.put("writedate_det_thresh", (Object)0.5);
        objectSetting.put("writedate_rec", (Object)false);
        objectSetting.put("table_det", (Object)true);
        objectSetting.put("seal_elim", (Object)true);
        objectSetting.put("seal_elim_type", (Object)"unet");
        objectSetting.put("watermark_elim", (Object)false);
        objectSetting.put("watermark_elim_thresh", (Object)100);
        objectSetting.put("seal_rec", (Object)true);
    }
}

