/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.externalserve.Knowledge;
import com.jxdinfo.idp.common.externalserve.KnowledgeBaseServer;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.nlp.NlpOldConfig;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor.AbstractItemExtractor;
import com.jxdinfo.idp.extract.util.ThreadPoolUtil;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class NlpItemExtractor
extends AbstractItemExtractor<FileBytesInfo, FileBytesInfo> {
    private static final Logger log = LoggerFactory.getLogger(NlpItemExtractor.class);
    @Autowired
    private KnowledgeBaseServer server;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.NLP.getImplCode(), ItemExtractorEnum.NLP.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public FileBytesInfo before(FileBytesInfo bytesInfo) {
        return bytesInfo;
    }

    @Override
    public List<ExtractRecord> extract(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        String kName = IdUtils.fastSimpleUUID();
        Knowledge knowledge = new Knowledge(kName);
        boolean flag = false;
        try {
            this.server.createKnowledgeBase(knowledge);
            this.server.uploadDoc(kName, bytesInfo);
        }
        catch (Exception e) {
            flag = true;
        }
        ArrayList nlpTypeInfos = new ArrayList();
        for (ExtractItemDto itemDto : itemDtoList) {
            List relevancyList = itemDto.getTypeInfoList();
            Iterator iterator = relevancyList.iterator();
            while (iterator.hasNext()) {
                ExtractTypeInfo info = (ExtractTypeInfo)iterator.next();
                info.setExtractItemId(itemDto.getId());
            }
            List nlpTypeInfos1 = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.NLP.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            nlpTypeInfos.addAll(nlpTypeInfos1);
        }
        CopyOnWriteArrayList<ExtractRecord> result = new CopyOnWriteArrayList<ExtractRecord>();
        CountDownLatch latch = new CountDownLatch(nlpTypeInfos.size());
        log.info("NLP>>> \u3010{}\u3011\u63d0\u53d6\u5f00\u59cb\u6267\u884c\uff0c\u5f00\u59cb\u65f6\u95f4\uff1a\u3010{}\u3011", (Object)bytesInfo.getFileName(), (Object)LocalDateTime.now());
        if (CollUtil.isNotEmpty(nlpTypeInfos)) {
            for (ExtractTypeInfo nlpTypeInfo : nlpTypeInfos) {
                boolean finalFlag = flag;
                ThreadPoolUtil.getInstance().execute(() -> {
                    Knowledge askKnowledge = new Knowledge();
                    BeanUtils.copyProperties((Object)knowledge, (Object)askKnowledge);
                    log.info("NLP>>>\u3010{}\u3011\u5f00\u59cb\u6267\u884c", (Object)(nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName()));
                    NlpOldConfig config = (NlpOldConfig)nlpTypeInfo.extractConfig(NlpOldConfig.class);
                    config.knowledge(askKnowledge);
                    ExtractRecord record = new ExtractRecord();
                    record.setItemName(nlpTypeInfo.getName());
                    record.setObjectId(nlpTypeInfo.getCode());
                    record.setExtractItemId(nlpTypeInfo.getExtractItemId());
                    if (finalFlag) {
                        record.setResultObject((Object)"\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                        record.setResult("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                    } else {
                        try {
                            askKnowledge.setSystem("\u4f60\u662f\u4e00\u540d\u6587\u6863\u5ba1\u67e5\u4eba\u5458\uff0c\u9700\u8981\u4ece\u6587\u672c\u4e2d\u63d0\u53d6\u5173\u952e\u4fe1\u606f\uff0c\u5e76\u6839\u636e\u8981\u6c42\u8fdb\u884c\u63a8\u7406\u5224\u65ad\uff0c\u7ed9\u51fa\u81ea\u5df1\u7684\u7ed3\u8bba\u3002");
                            String answer = this.server.chat(askKnowledge);
                            if (!StringUtils.isEmpty((Object)config.getRegex())) {
                                List match = MatchTextUtil.match((String)config.getRegex(), (String)answer);
                                StringBuilder answerAfter = new StringBuilder();
                                for (int i = 0; i < match.size(); ++i) {
                                    answerAfter.append((String)match.get(i));
                                    if (i == match.size() - 1) continue;
                                    answerAfter.append(" ");
                                }
                                record.setResult(answerAfter.toString());
                                record.setResultObject((Object)answerAfter.toString());
                            } else {
                                record.setResult(answer);
                                record.setResultObject((Object)answer);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u667a\u80fd\u95ee\u7b54\u63a5\u53e3\u54cd\u5e94\u5f02\u5e38", (Throwable)e);
                            record.setResultObject((Object)"\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                            record.setResult("\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002");
                        }
                    }
                    result.add(record);
                    log.info("NLP>>>\u3010{}\u3011\u6267\u884c\u7ed3\u675f\uff0c\u63d0\u53d6\u7ed3\u679c\u3010{}\u3011,\u7ed3\u675f\u65f6\u95f4\u3010{}\u3011", new Object[]{nlpTypeInfo.getExtractItemId() + ":" + nlpTypeInfo.getName(), record.getResult(), LocalDateTime.now()});
                    latch.countDown();
                });
            }
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("\u4e3b\u7ebf\u7a0b\u88ab\u4e2d\u65ad", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            this.server.deleteKnowledgeBase(knowledge);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u77e5\u8bc6\u5e93\u5931\u8d25", (Throwable)e);
        }
        return result;
    }
}

