/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTextRGConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="analysePDFTextArrayRGExtractor")
public class AnalysePDFTextArrayRGExtractor
extends AbstractChannelExtractor<FileBytesInfo, AnalysePDFTextRGConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TEXT_RG_ARRAY.getCode(), "\u5408\u540c\u660e\u7ec6\u89e3\u6790array");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(FileBytesInfo wordInfo, AnalysePDFTextRGConfig wordTableConfig) {
    }

    @Override
    public List<Object> extract(FileBytesInfo fileBytesInfo, AnalysePDFTextRGConfig config) {
        JSONObject structureInfo = ReadPdfUtil.getPDFTable((FileBytesInfo)fileBytesInfo);
        ArrayList<Object> result = new ArrayList<Object>();
        JSONArray textBlocks = structureInfo.getJSONArray("textBlocks");
        int k = 0;
        boolean start = false;
        if (!StringUtils.isEmpty((Object)config.getKeyword())) {
            k = this.findIndex(textBlocks, config.getKeyword());
            start = true;
            if (k == -1) {
                return this.getResultTable(result);
            }
        }
        boolean s = false;
        int maxKeyLengh = 0;
        boolean tablekey = !CollectionUtils.isEmpty((Collection)config.getTableKey()) && config.getTableKey().get(0) != null && !((String)config.getTableKey().get(0)).isEmpty();
        StringBuilder regex = new StringBuilder("(.*?)");
        StringBuilder rowRegex = new StringBuilder(")(.*?)(?=(");
        if (tablekey) {
            int j = config.getTableKey().size();
            for (int i = 0; i < j; ++i) {
                String tableKey = (String)config.getTableKey().get(i);
                regex.append(tableKey).append("[\uff1a:](.*?)");
                if (i > 0) {
                    rowRegex.append("|");
                }
                rowRegex.append(tableKey);
                if (tableKey.length() > maxKeyLengh) {
                    maxKeyLengh = tableKey.length();
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("row", (Object)0);
                jsonObject.put("col", (Object)i);
                jsonObject.put("text", (Object)tableKey);
                result.add(jsonObject);
            }
        } else {
            return this.getResultTable(result);
        }
        rowRegex.append("))");
        String text = AnalysePDFTextArrayRGExtractor.findMatchStr(k, textBlocks, config, regex.toString());
        if (StringUtil.isBlank((CharSequence)text)) {
            return this.getResultTable(result);
        }
        String[] infos = text.replaceAll("\\n", "").split((String)config.getTableKey().get(0));
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(infos));
        list.removeIf(StringUtils::isEmpty);
        int m = list.size();
        for (int l = 0; l < m; ++l) {
            String info = (String)config.getTableKey().get(0) + (String)list.get(l);
            int b = config.getTableKey().size();
            for (int n = 0; n < b; ++n) {
                String tableKey = (String)config.getTableKey().get(n);
                String r = "(?<=" + tableKey + "[:\uff1a]" + rowRegex;
                if (MatchTextUtil.isMatch((String)r, (String)info).booleanValue()) {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("row", (Object)(l + 1));
                    jsonObject.put("col", (Object)n);
                    jsonObject.put("text", (Object)MatchTextUtil.matchOne((String)r, (String)info).trim());
                    result.add(jsonObject);
                }
                if (n + 1 != b || MatchTextUtil.isMatch((String)r, (String)info).booleanValue()) continue;
                String a = "(?<=" + tableKey + "[:\uff1a])(.*)";
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("row", (Object)(l + 1));
                jsonObject.put("col", (Object)n);
                jsonObject.put("text", (Object)MatchTextUtil.matchOne((String)a, (String)info).trim());
                result.add(jsonObject);
            }
        }
        return this.getResultTable(result);
    }

    private static String findMatchStr(int start, JSONArray textBlocks, AnalysePDFTextRGConfig config, String regex) {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder strCache = new StringBuilder();
        int s = 0;
        for (int i = start; i < textBlocks.size(); ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!StringUtils.isEmpty((Object)config.getStopKey()) && MatchTextUtil.isMatch((String)config.getStopKey(), (String)textBlock.getString("text")).booleanValue()) {
                return stringBuilder.toString();
            }
            String text = textBlock.getString("text");
            if (StringUtil.isNotBlank((CharSequence)strCache)) {
                text = strCache + text;
                strCache = new StringBuilder();
            }
            if (!MatchTextUtil.isMatch((String)regex, (String)text).booleanValue()) {
                if (++s >= config.getStopLine()) {
                    return stringBuilder.toString();
                }
                strCache.append(text);
                continue;
            }
            stringBuilder.append(text);
        }
        return stringBuilder.toString();
    }

    public static void main(String[] args) {
        JSONArray array = new JSONArray();
        JSONObject textBlock = new JSONObject();
        textBlock.put("text", (Object)"\u5e8f\u53f7:0001\u3001\u540d\u79f0:\u51ff\u5ca9\u673a\uff08\u56fe\u53f7\uff1aCHY4000C.00\uff09-\u5439\u7070\u7ba1\u7ec4\u4ef6\u66f4\u6362\uff08 \u56fe");
        array.add((Object)textBlock);
        textBlock = new JSONObject();
        textBlock.put("text", (Object)"\u53f7\uff1aCHY4000A-01B\uff09 \u5355\u4f4d:\u4ef6 \u6570\u91cf:38.00 \u5355\u4ef7:330 \u5143 \u5355\u9879\u603b\u4ef7:12540 \u5143");
        array.add((Object)textBlock);
        textBlock = new JSONObject();
        textBlock.put("text", (Object)"\u5e8f\u53f7:0002\u3001\u540d\u79f0:\u51ff\u5ca9\u673a\uff08\u56fe\u53f7\uff1aCHY4000C.00\uff09-\u540e\u76d6\u66f4\u6362\uff08 \u56fe\u53f7\uff1a");
        array.add((Object)textBlock);
        textBlock = new JSONObject();
        textBlock.put("text", (Object)"CHY4000A-02B\uff09 \u5355\u4f4d:\u4ef6 \u6570\u91cf:20.00 \u5355\u4ef7:1450 \u5143 \u5355\u9879\u603b\u4ef7:29000 \u5143");
        array.add((Object)textBlock);
        textBlock = new JSONObject();
        textBlock.put("text", (Object)"\u5e8f\u53f7:0003\u3001\u540d\u79f0:\u51ff\u5ca9\u673a\uff08\u56fe\u53f7\uff1aCHY4000C.00\uff09-\u5934\u76d6\u66f4\u6362\uff08 \u56fe\u53f7\uff1a");
        array.add((Object)textBlock);
        textBlock = new JSONObject();
        textBlock.put("text", (Object)"CHY4000A-07\uff09 \u5355\u4f4d:\u4ef6 \u6570\u91cf:38.00 \u5355\u4ef7:390 \u5143 \u5355\u9879\u603b\u4ef7:14820 \u5143");
        array.add((Object)textBlock);
        textBlock = new JSONObject();
        textBlock.put("text", (Object)"CHY4000A-07\uff09 \u5355\u4f4d:\u4ef6 \u6570\u91cf:38.00 \u5355\u4ef7:390 \u5143 \u5355\u9879\u603b\u4ef7:14820 \u5143");
        array.add((Object)textBlock);
        AnalysePDFTextRGConfig config = new AnalysePDFTextRGConfig();
        config.setKeyword("\u660e\u7ec6\u5982\u4e0b\uff1a");
        config.setTableKey(new ArrayList());
        config.getTableKey().add("\u5e8f\u53f7");
        config.getTableKey().add("\u540d\u79f0");
        config.getTableKey().add("\u6570\u91cf");
        config.getTableKey().add("\u5355\u4ef7");
        config.getTableKey().add("\u5355\u9879\u603b\u4ef7");
        config.setStopLine(4);
        System.out.println(AnalysePDFTextArrayRGExtractor.findMatchStr(0, array, config, "(.*?)\u5e8f\u53f7[\uff1a:](.*?)\u540d\u79f0[\uff1a:](.*?)\u6570\u91cf[\uff1a:](.*?)\u5355\u4ef7[\uff1a:](.*?)\u5355\u9879\u603b\u4ef7[\uff1a:](.*?)"));
    }

    private List<Object> getResultTable(List<Object> result) {
        ArrayList<Object> ll = new ArrayList<Object>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cells", result);
        ll.add(jsonObject);
        return ll;
    }

    @Override
    public Object after(List<Object> list, AnalysePDFTextRGConfig config) {
        return list;
    }

    private JSONObject textToJSONObject(String text) {
        String[] chinese;
        JSONObject jsonObject = new JSONObject();
        String[] english = text.split(":");
        if (english.length + (chinese = text.split("\uff1a")).length == 2) {
            return jsonObject;
        }
        String[] texts = english.length > chinese.length ? english : chinese;
        String key = texts[0];
        int j = texts.length - 1;
        for (int i = 1; i < j; ++i) {
            String t = texts[i];
            String k = t.substring(t.trim().lastIndexOf(" ") + 1).trim();
            String v = t.substring(0, t.trim().lastIndexOf(" ")).trim();
            jsonObject.put(key, (Object)v);
            key = k;
        }
        jsonObject.put(key, (Object)texts[texts.length - 1]);
        return jsonObject;
    }

    private int findIndex(JSONArray textBlocks, String keyword) {
        int j = textBlocks.size();
        for (int i = 0; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!MatchTextUtil.isMatch((String)keyword, (String)textBlock.getString("text")).booleanValue()) continue;
            return i + 1;
        }
        return -1;
    }
}

