/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor.AbstractItemExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class DocInfoItemExtractor
extends AbstractItemExtractor<FileBytesInfo, JSONObject> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.INFO.getImplCode(), ItemExtractorEnum.INFO.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public JSONObject before(FileBytesInfo bytesInfo) {
        return JSONObject.parseObject((byte[])bytesInfo.getFileBytes(), (Feature[])new Feature[0]);
    }

    @Override
    public List<ExtractRecord> extract(JSONObject pdfInfo, List<ExtractItemDto> itemDtoList) {
        ArrayList<ExtractItemDto> wordItemDtos = new ArrayList<ExtractItemDto>();
        for (ExtractItemDto dto : itemDtoList) {
            List relevancyList = dto.getTypeInfoList();
            List excelTypeRelevancyList = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.INFO.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(excelTypeRelevancyList)) continue;
            dto.setTypeInfoList(excelTypeRelevancyList);
            wordItemDtos.add(dto);
        }
        return super.extract(pdfInfo, wordItemDtos);
    }
}

