/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.entity.TreeNode;
import com.jxdinfo.idp.common.util.SnowFlakeUtil;
import com.jxdinfo.idp.common.util.TreeUtil;
import com.jxdinfo.idp.common.util.uuid.IdUtils;
import com.jxdinfo.idp.dio.service.DocInfoIoService;
import com.jxdinfo.idp.extract.chain.service.IExtractChainService;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainNodeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractGroupDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractNode;
import com.jxdinfo.idp.extract.domain.dto.ExtractTypeDtoOld;
import com.jxdinfo.idp.extract.domain.dto.TestDto;
import com.jxdinfo.idp.extract.domain.po.ExtractGroup;
import com.jxdinfo.idp.extract.domain.po.ExtractGroupRel;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractItemDocRelevancy;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.domain.query.ExtractGroupQuery;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.enums.ExtractGroupEnum;
import com.jxdinfo.idp.extract.enums.ReturnTypeEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel1Enum;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.extract.mapper.ExtractGroupMapper;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import com.jxdinfo.idp.extract.service.IExtractGroupRelService;
import com.jxdinfo.idp.extract.service.IExtractGroupService;
import com.jxdinfo.idp.extract.service.IExtractItemDocRelevancyService;
import com.jxdinfo.idp.extract.service.IExtractItemService;
import com.jxdinfo.idp.extract.service.IExtractTypeInfoService;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExtractCoreServiceImpl
implements IExtractCoreService {
    @Autowired
    private IExtractGroupService groupService;
    @Autowired
    private IExtractGroupRelService groupRelService;
    @Autowired
    private IExtractItemService itemService;
    @Autowired
    private IExtractTypeInfoService typeRelService;
    @Autowired
    private IExtractCore core;
    @Autowired
    private IExtractItemDocRelevancyService itemDocRelevancyService;
    @Autowired
    private ExtractGroupMapper groupMapper;
    @Autowired
    private IExtractChainService iIExtractChainService;
    @Autowired
    private DocInfoIoService docInfoIoService;

    @PostConstruct
    private void init() {
        GroupLevel1Enum.init();
    }

    @Override
    public List<ExtractGroupDto> getTree() {
        return this.groupMapper.getTree();
    }

    @Override
    public List<ExtractNode> getTree(ExtractGroupQuery query) {
        List<ExtractNode> roots = this.groupMapper.getRoots(query);
        List<ExtractNode> nodes = this.groupMapper.getNodes(query);
        List groupIds = nodes.stream().map(TreeNode::getId).collect(Collectors.toList());
        groupIds.addAll(roots.stream().map(TreeNode::getId).collect(Collectors.toList()));
        roots.forEach(node -> {
            if (StringUtils.isEmpty((CharSequence)node.getKey())) {
                node.setKey(String.valueOf(node.getId()));
            }
        });
        nodes.forEach(node -> {
            if (StringUtils.isEmpty((CharSequence)node.getKey())) {
                node.setKey(String.valueOf(node.getId()));
            }
        });
        nodes.addAll(this.groupMapper.getItemNodes(new ExtractItemQuery(query.getName(), groupIds)));
        List tree = TreeUtil.getTree(nodes, roots);
        return tree;
    }

    @Override
    public List<ExtractItemDto> getItemList(ExtractItemQuery query) {
        ArrayList<ExtractItemDto> result = new ArrayList<ExtractItemDto>();
        List<ExtractItem> extractItemList = this.itemService.getList(query);
        if (extractItemList != null && !extractItemList.isEmpty()) {
            for (ExtractItem extractItem : extractItemList) {
                int type = extractItem.getMethod();
                ExtractItemDto extractItemDto = new ExtractItemDto();
                extractItemDto.setId(extractItem.getId());
                extractItemDto.setGroupId(extractItem.getGroupId());
                extractItemDto.setCode(extractItem.getCode());
                extractItemDto.setName(extractItem.getName());
                extractItemDto.setDescription(extractItem.getDescription());
                extractItemDto.setReturnType(extractItem.getReturnType());
                extractItemDto.setExceptionValue(extractItem.getExceptionValue());
                extractItemDto.setIntegrationType(extractItem.getIntegrationType());
                extractItemDto.setMethod(extractItem.getMethod());
                if (type == 1) {
                    extractItemDto.setExtractNodeList(this.iIExtractChainService.getInputNode(extractItem.getId()));
                }
                result.add(extractItemDto);
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ExtractGroup insertGroup(ExtractGroupDto dto) {
        dto.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        this.groupRelService.insertRel(dto.getParentId(), dto.getId());
        this.groupService.save(dto);
        return dto;
    }

    @Override
    public void updateGroup(ExtractGroupDto dto) {
        this.checkDefault(dto.getId(), "\u4fee\u6539");
        ExtractGroup group = (ExtractGroup)this.groupService.getById(dto.getId());
        if (group.getFlag() == 1) {
            this.groupRelService.changeGroup(dto.getParentId(), dto.getId());
        }
        this.groupService.updateById(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteGroup(Long id) {
        this.checkDefault(id, "\u5220\u9664");
        ExtractItemQuery query = new ExtractItemQuery();
        query.setGroupId(id);
        List<ExtractItem> extractItemList = this.itemService.getList(query);
        if (extractItemList != null && !extractItemList.isEmpty()) {
            throw new RuntimeException("\u8be5\u63d0\u53d6\u5e93\u4e0b\u5b58\u5728\u63d0\u53d6\u9879\u4fe1\u606f\uff0c\u8bf7\u5148\u5220\u9664\u63d0\u53d6\u9879\uff01");
        }
        List<ExtractGroupRel> rels = this.groupRelService.getByPid(id);
        ArrayList<Long> cIds = new ArrayList<Long>();
        cIds.add(id);
        if (CollUtil.isNotEmpty(rels)) {
            cIds.addAll(rels.stream().map(ExtractGroupRel::getCid).collect(Collectors.toList()));
        }
        this.itemService.delete(cIds);
        this.groupRelService.deleteByPid(id);
        this.groupService.removeByIds(cIds);
    }

    @Override
    public Long insert(ExtractItem item) {
        item.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
        item.setCode(IdUtils.simpleUUID());
        this.itemService.save(item);
        return item.getId();
    }

    @Override
    public void update(ExtractItem item) {
        this.itemService.updateById(item);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDelete(List<Long> ids) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(ExtractItem::getId, ids);
        List list = this.itemService.list((Wrapper)wrapper);
        List codes = list.stream().map(extractItem -> extractItem.getCode()).collect(Collectors.toList());
        LambdaQueryWrapper delWrapper = new LambdaQueryWrapper();
        delWrapper.in(ExtractTypeInfo::getCode, codes);
        this.typeRelService.remove((Wrapper)delWrapper);
        this.itemService.removeByIds(ids);
    }

    @Override
    public List<Map<String, String>> getReturnTypes() {
        return ReturnTypeEnum.getReturnTypes();
    }

    @Override
    public List<ExtractTypeDtoOld> getExtractTypeList() {
        return GroupLevel1Enum.get();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(ExtractItemDto dto) {
        ExtractItem item = (ExtractItem)this.itemService.getById(dto.getId());
        this.itemService.updateById(dto);
        this.typeRelService.deleteByCode(item.getCode());
        dto.getTypeInfoList().forEach(extractTypeInfo -> {
            extractTypeInfo.toConfig();
            extractTypeInfo.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
            extractTypeInfo.setCode(item.getCode());
        });
        this.typeRelService.saveBatch(dto.getTypeInfoList());
        if (dto.getDocId() != null) {
            this.itemDocRelevancyService.deleteByItemId(dto.getId());
            ExtractItemDocRelevancy extractItemDocRelevancy = new ExtractItemDocRelevancy();
            extractItemDocRelevancy.setId(Long.valueOf(SnowFlakeUtil.getFlowIdInstance().nextId()));
            extractItemDocRelevancy.setDocId(dto.getDocId());
            extractItemDocRelevancy.setExtractItemId(dto.getId());
            this.itemDocRelevancyService.save(extractItemDocRelevancy);
        }
    }

    @Override
    public ExtractItemDto getItemDto(Long itemId) {
        ExtractItem item = (ExtractItem)this.itemService.getById(itemId);
        ExtractItemDto dto = new ExtractItemDto();
        BeanUtils.copyProperties((Object)item, (Object)dto);
        dto.setTypeInfoList(this.typeRelService.getByCode(dto.getCode()));
        List<ExtractItemDocRelevancy> docs = this.itemDocRelevancyService.getByItemId(itemId);
        if (CollectionUtils.isNotEmpty(docs)) {
            dto.setDocId(docs.get(0).getDocId());
        }
        return dto;
    }

    @Override
    public Long itemStatistics() {
        return this.itemService.count();
    }

    @Override
    public ExtractRecord extractTest(ExtractItemDto dto) {
        FileBytesInfo fileBytesInfo = this.docInfoIoService.getFileBytesInfo(dto.getDocId());
        ArrayList<ExtractItemDto> list = new ArrayList<ExtractItemDto>();
        list.add(dto);
        List extractRecords = this.core.execute(list, fileBytesInfo);
        return (ExtractRecord)extractRecords.get(0);
    }

    @Override
    public List<ExtractRecord> test(Long id, MultipartFile file) throws IOException {
        ExtractItemQuery queryVo = new ExtractItemQuery();
        queryVo.getGroupIds().add(id);
        List<ExtractItemDto> list = this.itemService.getDtoList(queryVo);
        FileBytesInfo fileBytesInfo = new FileBytesInfo();
        fileBytesInfo.setFileBytes(file.getBytes());
        fileBytesInfo.setFileName(file.getOriginalFilename());
        String[] filePoint = file.getOriginalFilename().split("\\.");
        fileBytesInfo.setFileFormat(filePoint[filePoint.length - 1]);
        List extractRecords = this.core.execute(list, fileBytesInfo);
        return extractRecords;
    }

    @Override
    public List<ExtractRecord> test(TestDto dto) throws IOException {
        ExtractItem item = (ExtractItem)this.itemService.getById((Serializable)((Object)dto.getItemId()));
        ExtractChainItemDto chainItemDto = new ExtractChainItemDto();
        BeanUtils.copyProperties((Object)item, (Object)chainItemDto);
        ArrayList<ExtractChainItemDto> chainItemDtos = new ArrayList<ExtractChainItemDto>();
        chainItemDtos.add(chainItemDto);
        ArrayList<ExtractChainNodeDto> nodeDtos = new ArrayList<ExtractChainNodeDto>();
        for (MultipartFile file : dto.getFiles()) {
            Map fileMap = dto.getNodeFileMap();
            String fileName = file.getOriginalFilename();
            String nodeId = (String)fileMap.get(fileName);
            int i = file.getName().hashCode();
            if (nodeId == null) continue;
            ArrayList<FileBytesInfo> fileBytesInfos = new ArrayList<FileBytesInfo>();
            FileBytesInfo fileBytesInfo = new FileBytesInfo();
            fileBytesInfos.add(fileBytesInfo);
            fileBytesInfo.setFileFormat("xlsx");
            fileBytesInfo.setFileName(fileName);
            fileBytesInfo.setFileBytes(file.getBytes());
            ExtractChainNodeDto chainNodeDto = new ExtractChainNodeDto(nodeId, fileBytesInfos);
            nodeDtos.add(chainNodeDto);
        }
        return this.core.execute(chainItemDtos, nodeDtos);
    }

    private void checkDefault(Long id, String type) {
        if (Objects.equals(id, ExtractGroupEnum.DEFAULT_GROUP.getKey())) {
            throw new RuntimeException("\u3010\u9ed8\u8ba4\u5206\u7ec4\u3011\u4e0d\u80fd" + type + "\uff01");
        }
    }
}

