/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.extract.container.ChannelExtractorContainer;
import com.jxdinfo.idp.extract.container.ItemExtractorContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ExtractConfig;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.extractorOld.IChannelExtractor;
import com.jxdinfo.idp.extract.extractorOld.IItemExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractConfigEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractItemExtractor<E, S>
implements IItemExtractor<E, S> {
    private static final Logger log = LoggerFactory.getLogger(AbstractItemExtractor.class);

    @Override
    public void init() {
        ItemExtractorContainer.put(this.implCodeDto().getImplCode(), this);
    }

    @Override
    public List<?> execute(E e, List<ExtractItemDto> itemDtoList) {
        Object before;
        try {
            before = this.before(e);
        }
        catch (Exception exception) {
            log.error("\u524d\u7f6e\u5904\u7406\u5f02\u5e38\uff01", (Throwable)exception);
            return null;
        }
        return this.extract(before, itemDtoList);
    }

    @Override
    public List<ExtractRecord> extract(S s, List<ExtractItemDto> itemDtoList) {
        ArrayList<ExtractRecord> recordList = new ArrayList<ExtractRecord>();
        for (ExtractItemDto dto : itemDtoList) {
            ArrayList<Object> resultList = new ArrayList<Object>();
            for (ExtractTypeInfo relevancy : dto.getTypeInfoList()) {
                IChannelExtractor channelExtractor = ChannelExtractorContainer.get(relevancy.getExtractType());
                ExtractConfig extractConfig = StringUtils.isNotEmpty((String)relevancy.getConfig()) ? relevancy.extractConfig(ExtractConfigEnum.extractConfig((String)relevancy.getExtractType())) : (ExtractConfig)JSON.parseObject((String)JSON.toJSONString((Object)relevancy.getExtractConfig()), (Class)ExtractConfigEnum.extractConfig((String)relevancy.getExtractType()));
                extractConfig.setMatchStrategy(dto.getIntegrationType() == null ? 0 : dto.getIntegrationType());
                Object extractResult = null;
                try {
                    extractResult = channelExtractor.execute(s, extractConfig);
                }
                catch (Exception e) {
                    log.error("\u63d0\u53d6\u9879\u3010" + dto.getName() + "\u3011\u63d0\u53d6\u5f02\u5e38\uff01", (Throwable)e);
                }
                resultList.add(extractResult);
            }
            ExtractRecord record = this.extractRecord(dto);
            this.integration(record, resultList, dto.getIntegrationType(), dto.getExceptionValue());
            recordList.add(record);
        }
        return recordList;
    }

    protected void integration(ExtractRecord record, List<Object> resultList, Integer integrationType, String exceptionValue) {
        resultList.removeIf(o -> {
            if (o == null) {
                return true;
            }
            if (o instanceof List) {
                return CollUtil.isEmpty((Collection)((List)o));
            }
            return false;
        });
        if (CollUtil.isNotEmpty(resultList)) {
            Object result = resultList.get(0);
            if (1 == integrationType) {
                result = resultList.get(resultList.size() - 1);
            }
            record.setResult(JSON.toJSONString((Object)result));
            record.setResultObject(result == null ? exceptionValue : result);
        } else {
            record.setResult(exceptionValue);
            record.setResultObject((Object)exceptionValue);
        }
    }

    public ExtractRecord extractRecord(ExtractItemDto itemDto) {
        ExtractRecord record = new ExtractRecord();
        record.setExtractItemId(itemDto.getId());
        record.setItemName(itemDto.getName());
        return record;
    }
}

