/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.extractor;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.extract.container.ItemExtractorContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.extractor.AbstractExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class FileExtractor
extends AbstractExtractor<FileBytesInfo, FileBytesInfo> {
    private static final List<GroupLevel2Enum> EXTRACTOR_EXECUTE = new ArrayList<GroupLevel2Enum>();

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto("fileExtractor", "\u6587\u4ef6\u6d41\u63d0\u53d6\u5668");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public FileBytesInfo before(FileBytesInfo fileBytesInfo) {
        return fileBytesInfo;
    }

    @Override
    public List<ExtractRecord> extract(List<ExtractItemDto> itemList, FileBytesInfo bytesInfo) {
        HashMap<Long, ExtractRecord> extractResult = new HashMap<Long, ExtractRecord>();
        this.runExtract(itemList, bytesInfo, extractResult);
        ArrayList<ExtractRecord> result = new ArrayList<ExtractRecord>(extractResult.values());
        if (result.size() != itemList.size()) {
            itemList.forEach(item -> {
                if (extractResult.get(item.getId()) == null) {
                    ExtractRecord empty = new ExtractRecord();
                    empty.setExtractItemId(item.getId());
                    empty.setItemName(item.getName());
                    if ("table".equals(item.getReturnType())) {
                        empty.setResult(null);
                        empty.setResultObject(null);
                    } else {
                        empty.setResult("");
                        empty.setResultObject((Object)"");
                    }
                    result.add(empty);
                }
            });
        }
        return result;
    }

    private void runExtract(List<ExtractItemDto> itemList, FileBytesInfo bytesInfo, Map<Long, ExtractRecord> extractResult) {
        EXTRACTOR_EXECUTE.forEach(groupLevel2Enum -> {
            List<?> resultTem;
            ArrayList<ExtractItemDto> extractItemList = new ArrayList<ExtractItemDto>();
            for (ExtractItemDto itemDto : itemList) {
                List ocrTypeInfos;
                List infoList = itemDto.getTypeInfoList();
                if (!CollUtil.isNotEmpty((Collection)infoList) || !CollUtil.isNotEmpty(ocrTypeInfos = infoList.stream().filter(info -> groupLevel2Enum.equals((Object)GroupLevel3Enum.get((String)info.getExtractType()).getLevel2Enum())).collect(Collectors.toList())) || extractResult.get(itemDto.getId()) != null) continue;
                extractItemList.add(itemDto);
            }
            if (CollUtil.isNotEmpty(extractItemList) && CollUtil.isNotEmpty(resultTem = ItemExtractorContainer.get(this.getExtractorCode((GroupLevel2Enum)groupLevel2Enum)).execute(bytesInfo, extractItemList))) {
                resultTem.forEach(res -> {
                    if (StringUtils.isNotBlank((CharSequence)res.getResult()) && !"\"\"".equals(res.getResult())) {
                        extractResult.put(res.getExtractItemId(), (ExtractRecord)res);
                    }
                });
            }
        });
    }

    private String getExtractorCode(GroupLevel2Enum groupLevel2Enum) {
        if (GroupLevel2Enum.WORD.equals((Object)groupLevel2Enum)) {
            return ItemExtractorEnum.WORD.getImplCode();
        }
        if (GroupLevel2Enum.EXCEL.equals((Object)groupLevel2Enum)) {
            return ItemExtractorEnum.EXCEL.getImplCode();
        }
        if (GroupLevel2Enum.OCR.equals((Object)groupLevel2Enum)) {
            return ItemExtractorEnum.OCR.getImplCode();
        }
        if (GroupLevel2Enum.PDF.equals((Object)groupLevel2Enum)) {
            return ItemExtractorEnum.PDF.getImplCode();
        }
        if (GroupLevel2Enum.NLP.equals((Object)groupLevel2Enum)) {
            return ItemExtractorEnum.NLP.getImplCode();
        }
        return ItemExtractorEnum.WORD.getImplCode();
    }

    static {
        EXTRACTOR_EXECUTE.add(GroupLevel2Enum.WORD);
        EXTRACTOR_EXECUTE.add(GroupLevel2Enum.EXCEL);
        EXTRACTOR_EXECUTE.add(GroupLevel2Enum.OCR);
        EXTRACTOR_EXECUTE.add(GroupLevel2Enum.PDF);
        EXTRACTOR_EXECUTE.add(GroupLevel2Enum.NLP);
    }
}

