/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.params.common;

import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hutool.core.util.ReflectUtil;
import com.jxdinfo.idp.common.annotation.model.AttributeAnnotation;
import com.jxdinfo.idp.common.enums.DynamicFormElements;
import com.jxdinfo.idp.extract.chain.common.ExtractorUtils;
import com.jxdinfo.idp.extract.extractor.IExtractor;
import com.jxdinfo.idp.extract.params.annotation.ExtractorConfig;
import com.jxdinfo.idp.extract.params.entity.ExtractConfigField;
import com.jxdinfo.idp.extract.params.entity.ExtractOutputField;
import com.jxdinfo.idp.extract.params.exception.FieldValueNullException;
import com.jxdinfo.idp.extract.params.exception.FieldValueRegexException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ExtractorConfigUtils {
    public static List<ExtractConfigField> getConfigFields(IExtractor<?, ?, ?> extractor) {
        Field[] fields;
        ArrayList<ExtractConfigField> extractConfigFields = new ArrayList<ExtractConfigField>();
        Class<?> configClass = ExtractorUtils.getConfigClass(extractor);
        for (Field field : fields = ReflectUtil.getFields(configClass)) {
            ExtractorConfig extractorConfig = field.getAnnotation(ExtractorConfig.class);
            if (extractorConfig == null) continue;
            ExtractConfigField extractConfigField = new ExtractConfigField();
            extractConfigField.setName(extractorConfig.name());
            extractConfigField.setDescription(extractorConfig.description());
            extractConfigField.setCode(field.getName());
            extractConfigField.setType(extractorConfig.type());
            extractConfigField.setRequired(extractorConfig.isRequired());
            extractConfigField.setVariable(extractorConfig.isVariable());
            extractConfigField.setDefaultValue(extractorConfig.defaultValue());
            extractConfigField.setLinkage(false);
            extractConfigField.setRegex(extractorConfig.regex());
            extractConfigField.setValue(JSONArray.parse((String)extractorConfig.value()));
            extractConfigField.setUrl(extractorConfig.url());
            extractConfigField.setSelectCode(extractorConfig.selectCode());
            extractConfigField.setSelectName(extractorConfig.selectName());
            extractConfigFields.add(extractConfigField);
        }
        return extractConfigFields;
    }

    public static List<ExtractOutputField> getOutputFields(IExtractor extractor) {
        Field[] fields;
        ArrayList<ExtractOutputField> extractOutputFields = new ArrayList<ExtractOutputField>();
        Class<?> configClass = ExtractorUtils.getOutputClass(extractor);
        if (configClass.equals(String.class)) {
            ExtractOutputField extractOutputField = new ExtractOutputField();
            extractOutputField.setName("\u63d0\u53d6\u7ed3\u679c");
            extractOutputField.setDescription("\u63d0\u53d6\u7ed3\u679c");
            extractOutputField.setCode("result");
            extractOutputField.setType(DynamicFormElements.STRING);
            extractOutputFields.add(extractOutputField);
            return extractOutputFields;
        }
        for (Field field : fields = ReflectUtil.getFields(configClass)) {
            AttributeAnnotation attributeAnnotation = field.getAnnotation(AttributeAnnotation.class);
            if (attributeAnnotation == null) continue;
            ExtractOutputField extractOutputField = new ExtractOutputField();
            extractOutputField.setName(attributeAnnotation.name());
            extractOutputField.setDescription(attributeAnnotation.description());
            extractOutputField.setCode(field.getName());
            extractOutputField.setType(attributeAnnotation.type());
            extractOutputFields.add(extractOutputField);
        }
        return extractOutputFields;
    }

    public static void verifyValue(String nodeName, IExtractor extractor, JSONObject config) {
        List<ExtractConfigField> fields = ExtractorConfigUtils.getConfigFields(extractor);
        for (ExtractConfigField field : fields) {
            if (!field.isRequired()) continue;
            Object value = config.get((Object)field.getCode());
            if (value == null) {
                throw new FieldValueNullException(StrUtil.format((CharSequence)"{}\u914d\u7f6e{}\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{nodeName, field.getName()}));
            }
            String valueString = value.toString();
            if (value instanceof String && StringUtils.isBlank((CharSequence)valueString)) {
                throw new FieldValueNullException(StrUtil.format((CharSequence)"{}\u914d\u7f6e{}\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{nodeName, field.getName()}));
            }
            if (!StringUtils.isNotBlank((CharSequence)field.getRegex()) || ReUtil.isMatch((String)field.getRegex(), (CharSequence)valueString)) continue;
            throw new FieldValueRegexException(StrUtil.format((CharSequence)"{}\u914d\u7f6e{}\u683c\u5f0f\u4e0d\u6b63\u786e", (Object[])new Object[]{nodeName, field.getName()}));
        }
    }
}

