/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.word;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordRowInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordTableInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.word.WordTableConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="wordTableExtractorOld")
public class WordTableExtractor
extends AbstractChannelExtractor<WordInfo, WordTableConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.WORD_TABLE.getCode(), "\u8868\u683c");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(WordInfo wordInfo, WordTableConfig wordTableConfig) {
    }

    @Override
    public List<Object> extract(WordInfo structureInfo, WordTableConfig config) {
        ArrayList<Object> result = new ArrayList<Object>();
        List tableInfos = structureInfo.getTableInfos();
        List cellNames = config.getCellNames();
        if (CollUtil.isNotEmpty((Collection)cellNames)) {
            for (WordTableInfo tableInfo : tableInfos) {
                List rows = tableInfo.getRows();
                int index = 0;
                String cellName = (String)cellNames.get(index);
                block1: for (WordRowInfo row : rows) {
                    List cells = row.getCells();
                    for (WordCellInfo cell : cells) {
                        if (!MatchTextUtil.isFuzzyMatched((String)cellName, (String)cell.getText())) continue;
                        if (++index >= cellNames.size()) break block1;
                        cellName = (String)cellNames.get(index);
                    }
                }
                if (index != cellNames.size()) continue;
                result.add(tableInfo);
            }
        }
        return result;
    }

    @Override
    public Object after(List<Object> list, WordTableConfig config) {
        int matchStrategy = config.getMatchStrategy();
        if (CollUtil.isNotEmpty(list) && matchStrategy == 0) {
            return list.get(0);
        }
        return null;
    }
}

