/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.StringUtils;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTableConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="analysePDFTableExtractor")
public class AnalysePDFTableExtractor
extends AbstractChannelExtractor<JSONObject, AnalysePDFTableConfig> {
    private static final Logger log = LoggerFactory.getLogger(AnalysePDFTableExtractor.class);

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TABLE.getCode(), "\u53ef\u89e3\u6790pdf\u8868\u683c");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(JSONObject wordInfo, AnalysePDFTableConfig wordTableConfig) {
    }

    @Override
    public List<Object> extract(JSONObject structureInfo, AnalysePDFTableConfig config) {
        ArrayList<Object> result = new ArrayList<Object>();
        log.info("\u5f00\u59cb\u89e3\u6790pdf\u8868\u683c{}", (Object)JSONObject.toJSONString((Object)structureInfo).substring(0, 500));
        if (!ObjectUtil.isNull((Object)structureInfo.get((Object)"code"))) {
            log.error("\u89e3\u6790\u5931\u8d25,\u539f\u56e0{}", structureInfo.get((Object)"info"));
            return result;
        }
        JSONArray tables = structureInfo.getJSONArray("tables");
        if (ObjectUtil.isNotNull((Object)config.getTableIndex())) {
            int j = tables.size();
            for (int i = 0; i < j; ++i) {
                if (!Objects.equals(tables.getJSONObject(i).getInteger("index"), config.getTableIndex())) continue;
                result.add(tables.getJSONObject(i));
            }
        }
        if (CollUtil.isNotEmpty((Collection)config.getTableKey()) && StringUtils.isNotEmpty((String)((String)config.getTableKey().get(0)))) {
            for (String tableKeys : config.getTableKey()) {
                String[] tableKey = tableKeys.split(",");
                block2: for (int i = 0; i < tables.size(); ++i) {
                    JSONArray cells = tables.getJSONObject(i).getJSONArray("cells");
                    if (cells.size() == 0) continue;
                    int cellIndex = 0;
                    JSONObject cell = cells.getJSONObject(cellIndex);
                    for (int j = 0; j < tableKey.length; ++j) {
                        String head = tableKey[j];
                        while (!MatchTextUtil.isFuzzyMatched((String)head, (String)(cell.getString("text") == null ? "" : cell.getString("text")))) {
                            if (cell.getInteger("row") + 1 >= ReadPdfUtil.tablekeyLineStatic || ++cellIndex >= cells.size()) continue block2;
                            cell = cells.getJSONObject(cellIndex);
                        }
                        if (j != tableKey.length - 1) continue;
                        result.add(tables.getJSONObject(i));
                    }
                }
            }
        }
        log.info("\u8868\u683c\u63d0\u53d6\u7ed3\u675f");
        return result;
    }

    @Override
    public Object after(List<Object> list, AnalysePDFTableConfig config) {
        return new ArrayList<Object>(Arrays.asList(list.get(0)));
    }
}

