/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.ocr;

import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.config.ocr.OcrTextFromTableConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.util.ocr.Cell;
import com.jxdinfo.idp.extract.domain.util.ocr.OcrTable;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractor.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.util.StringUtils;

@Extractor(group=ExtractorGroupEnum.OCR, name="OCR-\u8868\u683c\u63d0\u53d6", order=25)
public class OcrTextFromTableExtractor
extends AbstractDefaultExtractor<OcrTable, String, OcrTextFromTableConfig> {
    @Override
    public ExtractorCarrier<String> outPut(List<OcrTable> input, OcrTextFromTableConfig config) {
        return null;
    }

    @Override
    protected Class<?> outputClass() {
        return null;
    }

    @Override
    public ExtractorEnum extractorEnum() {
        return null;
    }

    @Override
    public List<String> extract(List<OcrTable> tables, OcrTextFromTableConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        for (OcrTable table : tables) {
            ArrayList points = new ArrayList();
            List cells = table.getCells();
            for (Cell cell : cells) {
                if (!MatchTextUtil.isMatch((String)config.getCellRegex(), (String)cell.getText()).booleanValue()) continue;
                HashMap<String, Integer> point = new HashMap<String, Integer>();
                point.put("colIndex", cell.getCol_index() + config.getOffsetX());
                point.put("rowIndex", cell.getRow_index() + config.getOffsetY());
                points.add(point);
            }
            Iterator iterator = points.iterator();
            for (Cell cell : cells) {
                while (iterator.hasNext()) {
                    Map next = (Map)iterator.next();
                    if (!Objects.equals(cell.getCol_index(), next.get("colIndex")) || !Objects.equals(cell.getRow_index(), next.get("rowIndex"))) continue;
                    if (StringUtils.isEmpty((Object)config.getRegex())) {
                        result.add(cell.getText());
                    } else {
                        result.addAll(MatchTextUtil.match((String)config.getRegex(), (String)cell.getText()));
                    }
                    iterator.remove();
                }
            }
        }
        return result;
    }
}

