/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.chain.common;

import com.jxdinfo.idp.extract.extractor.IExtractor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class ExtractorUtils {
    public static Type getInputType(IExtractor extractor) {
        return ExtractorUtils.getType(extractor, 0);
    }

    public static Type getOutputType(IExtractor extractor) {
        return ExtractorUtils.getType(extractor, 1);
    }

    public static Type getConfigType(IExtractor extractor) {
        return ExtractorUtils.getType(extractor, 2);
    }

    public static Class<?> getInputClass(IExtractor extractor) {
        Class<?> cls;
        Type type = ExtractorUtils.getInputType(extractor);
        try {
            cls = Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return cls;
    }

    public static Class<?> getOutputClass(IExtractor extractor) {
        Class<?> cls;
        Type type = ExtractorUtils.getOutputType(extractor);
        try {
            cls = Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return cls;
    }

    public static Class<?> getConfigClass(IExtractor extractor) {
        Class<?> cls;
        Type type = ExtractorUtils.getConfigType(extractor);
        try {
            cls = Class.forName(type.getTypeName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return cls;
    }

    private static Type getType(IExtractor extractor, int index) {
        Type type = extractor.getClass().getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        if (type instanceof Class) {
            type = ((Class)type).getGenericSuperclass();
            return ((ParameterizedType)type).getActualTypeArguments()[index];
        }
        throw new ClassCastException("get class error,actual type is " + extractor.getClass().getCanonicalName());
    }
}

