/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.word;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.word.WordChapterConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="wordChapterExtractorOld")
public class WordChapterExtractor
extends AbstractChannelExtractor<WordInfo, WordChapterConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.WORD_CHAPTER.getCode(), "\u7ae0\u8282");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(WordInfo wordInfo, WordChapterConfig wordChapterConfig) {
    }

    @Override
    public List<Object> extract(WordInfo wordInfo, WordChapterConfig config) {
        List chapterInfos = wordInfo.getChapterInfos();
        ArrayList<Object> result = new ArrayList<Object>();
        for (WordChapterInfo chapterInfo : chapterInfos) {
            if (!this.match(chapterInfo.getTitleName(), config)) continue;
            result.add(chapterInfo);
        }
        return result;
    }

    @Override
    public Object after(List<Object> list, WordChapterConfig config) {
        int matchStrategy = config.getMatchStrategy();
        if (CollUtil.isNotEmpty(list) && matchStrategy == 0) {
            return list.get(0);
        }
        return null;
    }

    private boolean match(String title, WordChapterConfig config) {
        String matchText = config.getMatchText();
        if (config.getHandleMethod() == 0) {
            title = title.replaceAll(" |\n|", "");
            return title.contains(matchText);
        }
        if (config.getHandleMethod() == 1) {
            Pattern pattern = Pattern.compile(matchText);
            Matcher matcher = pattern.matcher(title);
            return matcher.find();
        }
        return false;
    }
}

