/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.container;

import cn.hutool.core.annotation.AnnotationUtil;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.IExtractor;
import com.jxdinfo.idp.extract.extractor.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.extractorOld.entity.ExtractorGroup;
import com.jxdinfo.idp.extract.extractorOld.entity.ExtractorInput;
import com.jxdinfo.idp.extract.extractorOld.entity.ExtractorType;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import com.jxdinfo.idp.extract.params.common.ExtractorConfigUtils;
import com.jxdinfo.liteflow.log.LFLog;
import com.jxdinfo.liteflow.log.LFLoggerManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExtractorContainer {
    private static final LFLog logger = LFLoggerManager.getLogger(ExtractorContainer.class);
    private static Map<String, IExtractor<?, ?, ?>> map = new HashMap();
    private static Map<IExtractor<?, ?, ?>, Extractor> extractor_map = new HashMap();

    public static IExtractor<?, ?, ?> extractor(String key) {
        return map.get(key);
    }

    public static void register(String key, IExtractor<?, ?, ?> extractor) {
        map.put(key, extractor);
        Extractor annotation = (Extractor)AnnotationUtil.getAnnotation(extractor.getClass(), Extractor.class);
        extractor_map.put(extractor, annotation);
    }

    public static List<ExtractorGroup> getExtractorGroups() {
        List extractorGroups = ExtractorGroupEnum.list();
        for (ExtractorGroup extractorGroup : extractorGroups) {
            ArrayList<ExtractorType> types = new ArrayList<ExtractorType>();
            extractor_map.forEach((extractor, annotation) -> {
                if (Objects.equals(annotation.group().getGroup().getCode(), extractorGroup.getCode())) {
                    ExtractorType extractorType = new ExtractorType();
                    extractorType.setName(annotation.name());
                    extractorType.setCode(extractor.key());
                    extractorType.setOrder(Integer.valueOf(annotation.order()));
                    extractorType.setConfigFields(ExtractorConfigUtils.getConfigFields(extractor));
                    ExtractorEnum current = ExtractorEnum.getByCode((String)extractor.key());
                    extractorType.setCategoryId(current.getCategoryId());
                    extractorType.setInput(new ExtractorInput(current.getInput().getCode(), current.getInput().getName()));
                    types.add(extractorType);
                }
            });
            types.sort(Comparator.comparingInt(ExtractorType::getOrder));
            extractorGroup.setTypes(types);
        }
        return extractorGroups;
    }
}

