/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.chain.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.extract.chain.common.ChainUtils;
import com.jxdinfo.idp.extract.chain.dto.CurrentExtractChain;
import com.jxdinfo.idp.extract.chain.dto.ExtractChain;
import com.jxdinfo.idp.extract.chain.dto.ExtractLink;
import com.jxdinfo.idp.extract.chain.dto.ExtractNode;
import com.jxdinfo.idp.extract.chain.dto.ResultDataAttribute;
import com.jxdinfo.idp.extract.chain.dto.ResultDataCategory;
import com.jxdinfo.idp.extract.chain.service.IExtractChainService;
import com.jxdinfo.idp.extract.chain.service.IResultDataCategoryService;
import com.jxdinfo.idp.extract.chain.vo.ChainError;
import com.jxdinfo.idp.extract.container.ExtractorContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.params.common.ExtractorConfigUtils;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import com.jxdinfo.idp.flow.config.model.IdpFlowChain;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.config.service.IdpFlowChainService;
import com.jxdinfo.idp.flow.domain.service.IdpFlowChainViewService;
import com.jxdinfo.idp.flow.domain.view.FlowChainView;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ExtractChainServiceImpl
implements IExtractChainService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractChainServiceImpl.class);
    @Resource
    private IdpFlowChainService idpFlowChainService;
    @Autowired
    private IExtractCoreService extractCoreService;
    @Resource
    private IdpFlowChainViewService idpFlowChainViewService;
    @Resource
    private IResultDataCategoryService resultDataCategoryService;

    @Override
    public ExtractChain getExtractChain(Long id) {
        ExtractChain extractChain = new ExtractChain();
        extractChain.setMethod(Integer.valueOf(1));
        IdpFlowChain idpFlowChain = (IdpFlowChain)this.idpFlowChainService.getById((Serializable)id);
        if (idpFlowChain == null) {
            ExtractItemDto itemDto = this.extractCoreService.getItemDto(id);
            if (itemDto == null) {
                throw new BusinessException("\u63d0\u53d6\u6d41\u7a0b\u4e0d\u5b58\u5728");
            }
            extractChain.setId(id);
            extractChain.setName(itemDto.getName());
            extractChain.setMethod(itemDto.getMethod());
            extractChain.setNodes(new ArrayList());
            extractChain.setLinks(new ArrayList());
            return extractChain;
        }
        FlowChainView flowChainView = this.idpFlowChainViewService.getById(id);
        extractChain.setId(flowChainView.getId());
        extractChain.setName(flowChainView.getName());
        extractChain.setView(flowChainView.getView());
        extractChain.setNodes(ChainUtils.tagToNodeBatch(flowChainView.getTags()));
        extractChain.setLinks(ChainUtils.flowLinkToLinkBatch(flowChainView.getLinks()));
        this.getDataMode(id, extractChain.getNodes());
        return extractChain;
    }

    @Override
    public List<ExtractNode> getInputNode(Long id) {
        List<IdpFlowTag> tags = this.idpFlowChainViewService.getTagByChainId(id);
        tags = tags.stream().filter(t -> Objects.equals(t.getInputType(), ExtractorEnum.FILE_BYTES_INFO.getCode())).collect(Collectors.toList());
        return ChainUtils.tagToNodeBatch(tags);
    }

    @Override
    public List<ResultDataCategory> getInputCategory(CurrentExtractChain currentExtractChain) {
        ArrayList<ResultDataCategory> result = new ArrayList<ResultDataCategory>();
        if (currentExtractChain == null) {
            throw new BusinessException("\u6d41\u7a0b\u6570\u636e\u7f3a\u5931");
        }
        if (StringUtils.isBlank((CharSequence)currentExtractChain.getCurrentNodeId())) {
            throw new BusinessException("\u5f53\u524d\u9009\u4e2d\u8282\u70b9\u6570\u636e\u7f3a\u5931");
        }
        List nodes = currentExtractChain.getNodes();
        List links = currentExtractChain.getLinks();
        if (CollectionUtils.isNotEmpty((Collection)links)) {
            List parents = links.stream().filter(link -> StringUtils.isNotBlank((CharSequence)link.getTargetId()) && StringUtils.isNotBlank((CharSequence)link.getSourceId()) && Objects.equals(link.getTargetId(), currentExtractChain.getCurrentNodeId())).collect(Collectors.toList());
            for (ExtractLink parent : parents) {
                ExtractNode extractNode = nodes.stream().filter(node -> Objects.equals(node.getId(), parent.getSourceId())).findFirst().orElse(null);
                if (extractNode == null || extractNode.getCategory() == null) continue;
                result.add(extractNode.getCategory());
            }
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ExtractChain saveExtractChain(ExtractChain extractChain) {
        try {
            LOGGER.info("\u4fdd\u5b58\u6d41\u7a0b\u5b9e\u4f53\u7c7b{}", (Object)extractChain);
            List<ChainError> errors = this.verify(extractChain);
            if (CollectionUtils.isNotEmpty(errors)) {
                throw new BusinessException(StrUtil.format((CharSequence)"\u4e0d\u80fd\u4fdd\u5b58\uff0c\u5f53\u524d\u6d41\u7a0b\u5b58\u5728\u9519\u8bef\uff1a{}", (Object[])new Object[]{errors.get(0).getMessage()}));
            }
            this.saveDataModel(extractChain.getId(), extractChain.getNodes());
            FlowChainView flowChainView = new FlowChainView();
            flowChainView.setId(extractChain.getId());
            flowChainView.setName(extractChain.getName());
            flowChainView.setView(extractChain.getView());
            flowChainView.setEl(ChainUtils.toEL(extractChain));
            flowChainView.setTags(ChainUtils.nodeToTagBatch(extractChain.getNodes()));
            flowChainView.setLinks(ChainUtils.linkToFlowLinkBatch(extractChain.getLinks()));
            this.idpFlowChainViewService.saveOrUpdate(flowChainView);
            return this.getExtractChain(extractChain.getId());
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u63d0\u53d6\u94fe\u5931\u8d25" + e.getMessage(), (Throwable)e);
            throw new BusinessException(StrUtil.format((CharSequence)"\u4fdd\u5b58\u63d0\u53d6\u94fe\u5931\u8d25\uff1a{}", (Object[])new Object[]{e.getMessage()}));
        }
    }

    @Override
    public List<ChainError> verify(ExtractChain extractChain) {
        List<ExtractNode> finalNodes;
        ArrayList<ChainError> errors = new ArrayList<ChainError>();
        List nodes = extractChain.getNodes();
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            errors.add(ChainError.error(null, (String)"\u63d0\u53d6\u6d41\u7a0b\u672a\u8bbe\u7f6e\u7ec4\u4ef6\uff0c\u8bf7\u62d6\u5165\u7ec4\u4ef6"));
        }
        List<ExtractNode> singleNodes = ChainUtils.getSingleNode(extractChain);
        if (CollectionUtils.isEmpty((Collection)nodes)) {
            for (ExtractNode extractNode : singleNodes) {
                errors.add(ChainError.error((String)extractNode.getId(), (String)StrUtil.format((CharSequence)"\u7ec4\u4ef6{}\u6ca1\u6709\u4e0e\u5176\u4ed6\u7ec4\u4ef6\u8fde\u63a5", (Object[])new Object[]{extractNode.getName()})));
            }
        }
        if (CollectionUtils.isEmpty(finalNodes = ChainUtils.getFinalNode(extractChain))) {
            errors.add(ChainError.error(null, (String)"\u65e0\u7ed3\u675f\u8282\u70b9"));
        }
        if (finalNodes.size() > 1) {
            errors.add(ChainError.error(null, (String)StrUtil.format((CharSequence)"\u4e0d\u5141\u8bb8\u51fa\u73b0\u591a\u4e2a\u8282\u70b9\u4f5c\u4e3a\u7ed3\u675f\u8282\u70b9\uff0c\u5f53\u524d\u7ed3\u675f\u8282\u70b9\u4e3a{}\u4e2a", (Object[])new Object[]{finalNodes.size()})));
        }
        errors.addAll(this.verifyNode(nodes));
        return errors;
    }

    private void saveDataModel(Long chainId, List<ExtractNode> nodes) {
        for (ExtractNode node : nodes) {
            ResultDataCategory dataCategory = node.getCategory();
            if (dataCategory == null) continue;
            this.resultDataCategoryService.saveResultDataCategory(chainId, dataCategory);
        }
    }

    private void getDataMode(Long chainId, List<ExtractNode> nodes) {
        for (ExtractNode node : nodes) {
            ResultDataCategory category = node.getCategory();
            if (category != null && category.getId() != null) {
                category = this.resultDataCategoryService.getResultDataCategory(chainId, category.getId());
            }
            node.setCategory(category);
        }
    }

    private List<ChainError> verifyDataModel(ExtractNode node) {
        ResultDataCategory dataCategory = node.getCategory();
        ArrayList<ChainError> errors = new ArrayList<ChainError>();
        if (dataCategory == null) {
            errors.add(ChainError.error(null, (String)StrUtil.format((CharSequence)"{}\u7684\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{node.getName()})));
        } else {
            if (dataCategory.getId() == null) {
                errors.add(ChainError.error(null, (String)StrUtil.format((CharSequence)"{}\u7684\u6570\u636e\u6a21\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{node.getName()})));
            }
            if (CollectionUtils.isEmpty((Collection)dataCategory.getAttributeList())) {
                errors.add(ChainError.error(null, (String)StrUtil.format((CharSequence)"{}\u6570\u636e\u6a21\u578b{}\u7684\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{node.getName(), dataCategory.getName()})));
            } else {
                for (ResultDataAttribute attribute : dataCategory.getAttributeList()) {
                    if (!Objects.equals("aggregation", node.getType())) continue;
                    if (attribute.getNodeId() == null) {
                        errors.add(ChainError.error(null, (String)StrUtil.format((CharSequence)"{}\u6570\u636e\u6a21\u578b{}\u5c5e\u6027{}\u672a\u9009\u62e9\u8282\u70b9", (Object[])new Object[]{node.getName(), dataCategory.getName(), attribute.getName()})));
                    }
                    if (!StringUtils.isBlank((CharSequence)attribute.getNodeKey())) continue;
                    errors.add(ChainError.error(null, (String)StrUtil.format((CharSequence)"{}\u6570\u636e\u6a21\u578b{}\u5c5e\u6027{}\u672a\u9009\u62e9\u5c5e\u6027", (Object[])new Object[]{node.getName(), dataCategory.getName(), attribute.getName()})));
                }
            }
        }
        return errors;
    }

    private List<ChainError> verifyNode(List<ExtractNode> nodes) {
        ArrayList<ChainError> errors = new ArrayList<ChainError>();
        for (ExtractNode node : nodes) {
            try {
                JSONObject jsonObject;
                String type;
                if (StringUtils.isNotEmpty((CharSequence)node.getConfig()) && StringUtils.isNotEmpty((CharSequence)(type = (jsonObject = JSONObject.parseObject((String)node.getConfig())).getString("type")))) {
                    ExtractorConfigUtils.verifyValue(node.getName(), ExtractorContainer.extractor(type), jsonObject);
                }
                errors.addAll(this.verifyDataModel(node));
            }
            catch (RuntimeException re) {
                errors.add(ChainError.error((String)node.getId(), (String)StrUtil.format((CharSequence)"{}\u53d1\u751f\u9519\u8bef{}", (Object[])new Object[]{node.getName(), re.getMessage()})));
            }
            catch (Exception e) {
                errors.add(ChainError.error((String)node.getId(), (String)StrUtil.format((CharSequence)"{}\u914d\u7f6e\u53c2\u6570\u683c\u5f0f\u9519\u8bef", (Object[])new Object[]{node.getName()})));
            }
        }
        return errors;
    }
}

