/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.chain.service.impl;

import com.jxdinfo.hutool.core.util.StrUtil;
import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.extract.chain.dto.ResultDataAttribute;
import com.jxdinfo.idp.extract.chain.dto.ResultDataCategory;
import com.jxdinfo.idp.extract.chain.service.IResultDataCategoryService;
import com.jxdinfo.idp.extract.domain.po.ExtractAttributeRelevancy;
import com.jxdinfo.idp.extract.service.ExtractAttributeRelevancyService;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import com.jxdinfo.idp.model.base.po.Attribute;
import com.jxdinfo.idp.model.service.IIDPDataModelService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ResultDataCategoryServiceImpl
implements IResultDataCategoryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultDataCategoryServiceImpl.class);
    @Resource
    private IIDPDataModelService dataModelService;
    @Resource
    private ExtractAttributeRelevancyService extractAttributeRelevancyService;

    @Override
    public ResultDataCategory getResultDataCategory(Long chainId, Long categoryId) {
        ResultDataCategory category = new ResultDataCategory();
        CategoryDto categoryDto = this.dataModelService.getDetail(categoryId);
        if (categoryDto == null) {
            throw new BusinessException("\u6a21\u578b\u4e0d\u5b58\u5728");
        }
        List attributes = categoryDto.getAttributeList();
        if (CollectionUtils.isEmpty((Collection)attributes)) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u6a21\u578b{}\u5c5e\u6027\u4e3a\u7a7a", (Object[])new Object[]{category.getName()}));
        }
        List<ExtractAttributeRelevancy> extractAttributeRelevancies = this.extractAttributeRelevancyService.selectByChainId(chainId);
        if (CollectionUtils.isEmpty(extractAttributeRelevancies)) {
            throw new BusinessException(StrUtil.format((CharSequence)"\u6a21\u578b{}\u5c5e\u6027\u4e0e\u8282\u70b9\u5173\u7cfb\u4e3a\u7a7a", (Object[])new Object[]{category.getName()}));
        }
        BeanUtils.copyProperties((Object)categoryDto, (Object)category);
        if (CollectionUtils.isNotEmpty((Collection)attributes)) {
            ArrayList<ResultDataAttribute> dataAttributes = new ArrayList<ResultDataAttribute>();
            for (Attribute attribute : attributes) {
                ResultDataAttribute dataAttribute = new ResultDataAttribute();
                BeanUtils.copyProperties((Object)attribute, (Object)dataAttribute);
                for (ExtractAttributeRelevancy extractAttributeRelevancy : extractAttributeRelevancies) {
                    if (!Objects.equals(extractAttributeRelevancy.getAttributeId(), attribute.getId())) continue;
                    dataAttribute.setNodeId(extractAttributeRelevancy.getNodeId());
                    dataAttribute.setNodeKey(extractAttributeRelevancy.getNodeKey());
                }
                dataAttributes.add(dataAttribute);
            }
            category.setAttributeList(dataAttributes);
        }
        return category;
    }

    @Override
    public void saveResultDataCategory(Long chainId, ResultDataCategory resultDataCategory) {
        CategoryDto categoryDto = new CategoryDto();
        BeanUtils.copyProperties((Object)resultDataCategory, (Object)categoryDto);
        ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
        for (ResultDataAttribute dataAttribute : resultDataCategory.getAttributeList()) {
            Attribute attribute = new Attribute();
            BeanUtils.copyProperties((Object)dataAttribute, (Object)attribute);
            attributeList.add(attribute);
        }
        categoryDto.setAttributeList(attributeList);
        if (resultDataCategory.getId() == null) {
            this.dataModelService.add(categoryDto);
        } else {
            this.dataModelService.edit(categoryDto);
        }
        ArrayList<ExtractAttributeRelevancy> relevancies = new ArrayList<ExtractAttributeRelevancy>();
        for (ResultDataAttribute dataAttribute : resultDataCategory.getAttributeList()) {
            ExtractAttributeRelevancy relevancy = new ExtractAttributeRelevancy();
            relevancy.setAttributeId(dataAttribute.getId());
            relevancy.setNodeId(dataAttribute.getNodeId());
            relevancy.setNodeKey(dataAttribute.getNodeKey());
            relevancies.add(relevancy);
        }
        this.extractAttributeRelevancyService.updateAttributeRelevancys(chainId, relevancies);
    }
}

