/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTextRGConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component(value="analysePDFTextArrayRGExtractor")
public class AnalysePDFTextArrayRGExtractor
extends AbstractChannelExtractor<JSONObject, AnalysePDFTextRGConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TEXT_RG_ARRAY.getCode(), "\u5408\u540c\u660e\u7ec6\u89e3\u6790array");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(JSONObject wordInfo, AnalysePDFTextRGConfig wordTableConfig) {
    }

    @Override
    public List<Object> extract(JSONObject structureInfo, AnalysePDFTextRGConfig config) {
        int i;
        int j;
        ArrayList<Object> result = new ArrayList<Object>();
        JSONArray textBlocks = structureInfo.getJSONArray("textBlocks");
        int k = 0;
        boolean start = false;
        if (!StringUtils.isEmpty((Object)config.getKeyword())) {
            k = this.findIndex(textBlocks, config.getKeyword());
            start = true;
            if (k == -1) {
                return result;
            }
        }
        int s = 0;
        int maxKeyLengh = 0;
        boolean tablekey = !CollectionUtils.isEmpty((Collection)config.getTableKey()) && config.getTableKey().get(0) != null && !((String)config.getTableKey().get(0)).isEmpty();
        StringBuilder regex = new StringBuilder("(.*?)");
        StringBuilder rowRegex = new StringBuilder(")(.*?)(?=(");
        if (tablekey) {
            j = config.getTableKey().size();
            for (i = 0; i < j; ++i) {
                String tableKey = (String)config.getTableKey().get(i);
                regex.append(tableKey).append("[\uff1a:](.*?)");
                if (i > 0) {
                    rowRegex.append("|");
                }
                rowRegex.append(tableKey);
                if (tableKey.length() > maxKeyLengh) {
                    maxKeyLengh = tableKey.length();
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("row", (Object)0);
                jsonObject.put("col", (Object)i);
                jsonObject.put("text", (Object)tableKey);
                result.add(jsonObject);
            }
        } else {
            return result;
        }
        rowRegex.append("))");
        j = textBlocks.size();
        for (i = k; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!StringUtils.isEmpty((Object)config.getStopKey()) && MatchTextUtil.isMatch((String)config.getStopKey(), (String)textBlock.getString("text")).booleanValue()) {
                return result;
            }
            String text = textBlock.getString("text");
            if (!MatchTextUtil.isMatch((String)regex.toString(), (String)text).booleanValue()) {
                if (!start || ++s < config.getStopLine()) continue;
                return result;
            }
            String[] infos = text.replaceAll("\\n", "").split((String)config.getTableKey().get(0));
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(infos));
            list.removeIf(StringUtils::isEmpty);
            int m = list.size();
            for (int l = 0; l < m; ++l) {
                String info = (String)config.getTableKey().get(0) + (String)list.get(l);
                int b = config.getTableKey().size();
                for (int n = 0; n < b; ++n) {
                    String tableKey = (String)config.getTableKey().get(n);
                    String r = "(?<=" + tableKey + "[:\uff1a]" + rowRegex;
                    if (MatchTextUtil.isMatch((String)r, (String)info).booleanValue()) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("row", (Object)(l + 1));
                        jsonObject.put("col", (Object)n);
                        jsonObject.put("text", (Object)MatchTextUtil.matchOne((String)r, (String)info).trim());
                        result.add(jsonObject);
                    }
                    if (n + 1 != b || MatchTextUtil.isMatch((String)r, (String)info).booleanValue()) continue;
                    String a = "(?<=" + tableKey + "[:\uff1a])(.*)";
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("row", (Object)(l + 1));
                    jsonObject.put("col", (Object)n);
                    jsonObject.put("text", (Object)MatchTextUtil.matchOne((String)a, (String)info).trim());
                    result.add(jsonObject);
                }
            }
        }
        return result;
    }

    @Override
    public Object after(List<Object> list, AnalysePDFTextRGConfig config) {
        return list;
    }

    private JSONObject textToJSONObject(String text) {
        String[] chinese;
        JSONObject jsonObject = new JSONObject();
        String[] english = text.split(":");
        if (english.length + (chinese = text.split("\uff1a")).length == 2) {
            return jsonObject;
        }
        String[] texts = english.length > chinese.length ? english : chinese;
        String key = texts[0];
        int j = texts.length - 1;
        for (int i = 1; i < j; ++i) {
            String t = texts[i];
            String k = t.substring(t.trim().lastIndexOf(" ") + 1).trim();
            String v = t.substring(0, t.trim().lastIndexOf(" ")).trim();
            jsonObject.put(key, (Object)v);
            key = k;
        }
        jsonObject.put(key, (Object)texts[texts.length - 1]);
        return jsonObject;
    }

    private int findIndex(JSONArray textBlocks, String keyword) {
        int j = textBlocks.size();
        for (int i = 0; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!MatchTextUtil.isMatch((String)keyword, (String)textBlock.getString("text")).booleanValue()) continue;
            return i + 1;
        }
        return -1;
    }
}

