/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.info;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.info.InfoExtractConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import com.jxdinfo.idp.extract.mapper.ExtractAttributeRelevancyMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component(value="docInfoSQLExtractor")
public class DocInfoSQLExtractor
extends AbstractChannelExtractor<JSONObject, InfoExtractConfig> {
    @Resource
    private ExtractAttributeRelevancyMapper extractAttributeRelevancyMapper;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.INFO_EXTRACT.getCode(), "\u6587\u6863\u4fe1\u606f\u63d0\u53d6\u540e\u6267\u884csql");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(JSONObject wordInfo, InfoExtractConfig config) {
    }

    @Override
    public List<Object> extract(JSONObject structureInfo, InfoExtractConfig config) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (ObjectUtil.isNotNull((Object)config.getExtractSQL())) {
            String sql = config.getExtractSQL().replaceAll("(?i)update ", "").replaceAll("(?i)insert ", "").replaceAll("(?i)delete ", "");
            for (String key : structureInfo.keySet()) {
                sql = sql.replaceAll("\\{" + key + "}", structureInfo.getString(key));
            }
            result.addAll(this.extractAttributeRelevancyMapper.docInfoSQLExtractor(sql));
        }
        return result;
    }

    @Override
    public Object after(List<Object> list, InfoExtractConfig config) {
        return list;
    }
}

