/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.interf.impl;

import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.extract.chain.context.SimpleExtraceContext;
import com.jxdinfo.idp.extract.container.ExtractorOldContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainItemDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractChainNodeDto;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractItem;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.query.ExtractItemQuery;
import com.jxdinfo.idp.extract.extractorOld.IExtractor;
import com.jxdinfo.idp.extract.interf.IExtractCore;
import com.jxdinfo.idp.extract.service.IExtractCoreService;
import com.jxdinfo.idp.extract.service.IExtractItemService;
import com.jxdinfo.idp.flow.engine.IdpFlowExecutor;
import com.jxdinfo.idp.flow.engine.model.IdpFlowInstance;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExtractCoreImpl
implements IExtractCore {
    @Autowired
    private IExtractItemService itemService;
    @Autowired
    private IExtractCoreService extractCoreService;
    @Resource
    private IdpFlowExecutor idpFlowExecutor;

    public List<ExtractRecord> execute(List<ExtractItemDto> itemDtoList, FileBytesInfo bytesInfo) {
        IExtractor extractor = ExtractorOldContainer.get("fileExtractor");
        return extractor.execute(itemDtoList, bytesInfo);
    }

    public List<ExtractRecord> execute(List<ExtractChainItemDto> itemDtoList, List<ExtractChainNodeDto> nodeDtoList) {
        ArrayList<ExtractRecord> records = new ArrayList<ExtractRecord>();
        for (ExtractChainItemDto extractChainItemDto : itemDtoList) {
            SimpleExtraceContext simpleExtraceContext = new SimpleExtraceContext();
            for (ExtractChainNodeDto extractChainNodeDto : nodeDtoList) {
                simpleExtraceContext.getNodeMap().put(extractChainNodeDto.getId(), extractChainNodeDto);
            }
            IdpFlowInstance instance = this.idpFlowExecutor.execute(extractChainItemDto.getId(), (Object)simpleExtraceContext);
            ExtractRecord record = new ExtractRecord();
            record.setExtractItemId(extractChainItemDto.getId());
            record.setResultObject((Object)instance.getResult());
            records.add(record);
        }
        return records;
    }

    public List<ExtractItemDto> getExtractItemList(ExtractItemQuery queryVo) {
        return this.itemService.getDtoList(queryVo);
    }

    public List<ExtractItemDto> getExtractItemsByIds(List<Long> ids) {
        ExtractItemQuery query = new ExtractItemQuery();
        query.setIds(ids);
        return this.getExtractItemList(query);
    }

    public ExtractItem findById(long itemId) {
        return (ExtractItem)this.itemService.getById(Long.valueOf(itemId));
    }

    public long save(ExtractItem extractItem) {
        return this.extractCoreService.insert(extractItem);
    }
}

