/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.extractor;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.extract.container.ItemExtractorContainer;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.extractor.AbstractExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class FileExtractor
extends AbstractExtractor<FileBytesInfo, FileBytesInfo> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto("fileExtractor", "\u6587\u4ef6\u6d41\u63d0\u53d6\u5668");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public FileBytesInfo before(FileBytesInfo fileBytesInfo) {
        return fileBytesInfo;
    }

    @Override
    public List<ExtractRecord> extract(List<ExtractItemDto> itemList, FileBytesInfo bytesInfo) {
        ArrayList<ExtractRecord> result = new ArrayList<ExtractRecord>();
        ArrayList<ExtractItemDto> wordItemList = new ArrayList<ExtractItemDto>();
        ArrayList<ExtractItemDto> excelItemList = new ArrayList<ExtractItemDto>();
        ArrayList<ExtractItemDto> ocrItemList = new ArrayList<ExtractItemDto>();
        ArrayList<ExtractItemDto> nlpItemList = new ArrayList<ExtractItemDto>();
        for (ExtractItemDto itemDto : itemList) {
            List infoList = itemDto.getTypeInfoList();
            if (!CollUtil.isNotEmpty((Collection)infoList)) continue;
            ExtractTypeInfo info = (ExtractTypeInfo)infoList.get(0);
            GroupLevel2Enum level2Enum = GroupLevel3Enum.get((String)info.getExtractType()).getLevel2Enum();
            if (GroupLevel2Enum.WORD.equals((Object)level2Enum)) {
                wordItemList.add(itemDto);
                continue;
            }
            if (GroupLevel2Enum.EXCEL.equals((Object)level2Enum)) {
                excelItemList.add(itemDto);
                continue;
            }
            if (GroupLevel2Enum.OCR.equals((Object)level2Enum)) {
                ocrItemList.add(itemDto);
                continue;
            }
            nlpItemList.add(itemDto);
        }
        if (CollUtil.isNotEmpty(wordItemList)) {
            result.addAll(ItemExtractorContainer.get(ItemExtractorEnum.WORD.getImplCode()).execute(bytesInfo, wordItemList));
        }
        if (CollUtil.isNotEmpty(excelItemList)) {
            result.addAll(ItemExtractorContainer.get(ItemExtractorEnum.EXCEL.getImplCode()).execute(bytesInfo, excelItemList));
        }
        if (CollUtil.isNotEmpty(ocrItemList)) {
            result.addAll(ItemExtractorContainer.get(ItemExtractorEnum.OCR.getImplCode()).execute(bytesInfo, ocrItemList));
        }
        if (CollUtil.isNotEmpty(nlpItemList)) {
            result.addAll(ItemExtractorContainer.get(ItemExtractorEnum.NLP.getImplCode()).execute(bytesInfo, nlpItemList));
        }
        return result;
    }
}

