/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.word;

import com.jxdinfo.idp.common.entity.util.docparse.word.WordChapterInfo;
import com.jxdinfo.idp.common.entity.util.docparse.word.WordInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.config.word.WordChapterConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractor.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Word-\u7ae0\u8282\u63d0\u53d6", order=12)
public class WordChapterExtractor
extends AbstractDefaultExtractor<WordInfo, WordChapterInfo, WordChapterConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.WORD_CHAPTER;
    }

    @Override
    public Class<?> outputClass() {
        return WordChapterInfo.class;
    }

    @Override
    public List<WordChapterInfo> extract(List<WordInfo> wordInfos, WordChapterConfig config) {
        ArrayList<WordChapterInfo> result = new ArrayList<WordChapterInfo>();
        for (WordInfo wordInfo : wordInfos) {
            for (WordChapterInfo chapterInfo : wordInfo.getChapterInfos()) {
                if (!MatchTextUtil.matchOld((String)config.getChapterName(), (String)chapterInfo.getTitleName())) continue;
                result.add(chapterInfo);
            }
        }
        return result;
    }

    @Override
    public ExtractorCarrier<WordChapterInfo> outPut(List<WordInfo> wordInfos, WordChapterConfig config) {
        ArrayList<WordChapterInfo> data = new ArrayList<WordChapterInfo>();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (WordInfo wordInfo : wordInfos) {
            for (WordChapterInfo chapterInfo : wordInfo.getChapterInfos()) {
                if (!MatchTextUtil.matchOld((String)config.getChapterName(), (String)chapterInfo.getTitleName())) continue;
                locations.add(new Location(chapterInfo.getTitleName()));
                data.add(chapterInfo);
            }
        }
        return this.carrier(data, locations);
    }
}

