/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTextRGConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component(value="analysePDFTextRGExtractor")
public class AnalysePDFTextRGExtractor
extends AbstractChannelExtractor<JSONObject, AnalysePDFTextRGConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TABLE.getCode(), "\u53ef\u89e3\u6790pdf\u8868\u683c");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(JSONObject wordInfo, AnalysePDFTextRGConfig wordTableConfig) {
    }

    @Override
    public List<Object> extract(JSONObject structureInfo, AnalysePDFTextRGConfig config) {
        ArrayList<Object> result = new ArrayList<Object>();
        JSONArray textBlocks = structureInfo.getJSONArray("textBlocks");
        int k = 0;
        if (!StringUtils.isEmpty((Object)config.getKeyword()) && (k = this.findIndex(textBlocks, config.getKeyword())) == -1) {
            return result;
        }
        int s = 0;
        boolean start = false;
        boolean tablekey = ObjectUtil.isNotNull((Object)config.getTableKey());
        int j = textBlocks.size();
        for (int i = k; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (MatchTextUtil.isMatch((String)config.getStopKey(), (String)textBlock.getString("text")).booleanValue()) {
                return result;
            }
            JSONObject jsonObject = this.textToJSONObject(textBlock.getString("text"));
            if (jsonObject.isEmpty() && start) {
                if (++s < config.getStopLine()) continue;
                return result;
            }
            if (tablekey) {
                boolean isKey = true;
                int m = config.getTableKey().size();
                for (int l = 0; l < m; ++l) {
                    String vv = (String)config.getTableKey().get(l);
                    if (jsonObject.containsKey((Object)vv)) continue;
                    isKey = false;
                    if (!start) continue;
                    if (++s < config.getStopLine()) break;
                    return result;
                }
                if (isKey) continue;
            }
            result.add(jsonObject);
            start = true;
        }
        return result;
    }

    @Override
    public Object after(List<Object> list, AnalysePDFTextRGConfig config) {
        return list;
    }

    private JSONObject textToJSONObject(String text) {
        String[] chinese;
        JSONObject jsonObject = new JSONObject();
        String[] english = text.split(":");
        if (english.length + (chinese = text.split("\uff1a")).length == 2) {
            return jsonObject;
        }
        String[] texts = english.length > chinese.length ? english : chinese;
        String key = texts[0];
        int j = texts.length - 1;
        for (int i = 1; i < j; ++i) {
            String t = texts[i];
            String k = t.substring(t.trim().lastIndexOf(" ") + 1).trim();
            String v = t.substring(0, t.trim().lastIndexOf(" ")).trim();
            jsonObject.put(key, (Object)v);
            key = k;
        }
        jsonObject.put(key, (Object)texts[texts.length - 1]);
        return jsonObject;
    }

    private int findIndex(JSONArray textBlocks, String keyword) {
        int j = textBlocks.size();
        for (int i = 0; i < j; ++i) {
            JSONObject textBlock = textBlocks.getJSONObject(i);
            if (!MatchTextUtil.isMatch((String)keyword, (String)textBlock.getString("text")).booleanValue()) continue;
            return i + 1;
        }
        return -1;
    }
}

