/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.pdf;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.pdf.AnalysePDFTableConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component(value="analysePDFTableExtractor")
public class AnalysePDFTableExtractor
extends AbstractChannelExtractor<JSONObject, AnalysePDFTableConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.ANALYSE_PDF_TABLE.getCode(), "\u53ef\u89e3\u6790pdf\u8868\u683c");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(JSONObject wordInfo, AnalysePDFTableConfig wordTableConfig) {
    }

    @Override
    public List<Object> extract(JSONObject structureInfo, AnalysePDFTableConfig config) {
        int i;
        int j;
        ArrayList<Object> result = new ArrayList<Object>();
        JSONArray tables = structureInfo.getJSONArray("tables");
        if (ObjectUtil.isNotNull((Object)config.getTableIndex())) {
            j = tables.size();
            for (i = 0; i < j; ++i) {
                if (!Objects.equals(tables.getJSONObject(i).getInteger("index"), config.getTableIndex())) continue;
                result.add(tables.getJSONObject(i));
            }
        }
        if (CollUtil.isNotEmpty((Collection)config.getTableKey())) {
            j = tables.size();
            block1: for (i = 0; i < j; ++i) {
                JSONArray cells = tables.getJSONObject(i).getJSONArray("cells");
                int l = cells.size();
                for (int k = 0; k < l; ++k) {
                    JSONObject cell = cells.getJSONObject(k);
                    int n = config.getTableKey().size();
                    for (int m = 0; m < n; ++m) {
                        if (MatchTextUtil.match((String)cell.getString("text"), (String)((String)config.getTableKey().get(m))).isEmpty()) continue;
                        result.add(tables.getJSONObject(i));
                        continue block1;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public Object after(List<Object> list, AnalysePDFTableConfig config) {
        return list;
    }
}

