/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.excel;

import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.excel.ExcelObjectConfig;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.impl.channelextractor.AbstractChannelExtractor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class ExcelObjectExtractor
extends AbstractChannelExtractor<ExcelInfo, ExcelObjectConfig> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(GroupLevel3Enum.EXCEL_OBJECT.getCode(), "excel\u5bf9\u8c61");
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public void before(ExcelInfo excelInfo, ExcelObjectConfig excelObjectConfig) {
    }

    @Override
    public List<Object> extract(ExcelInfo excelInfo, ExcelObjectConfig config) {
        ArrayList<Object> result = new ArrayList<Object>();
        List sheetInfos = excelInfo.getSheetInfos();
        ExcelSheetInfo targetSheet = null;
        for (ExcelSheetInfo sheetInfo : sheetInfos) {
            if (!MatchTextUtil.matchOld((String)config.getSheetName(), (String)sheetInfo.getName())) continue;
            targetSheet = sheetInfo;
            break;
        }
        if (targetSheet != null) {
            ExcelCellInfo[][] cellArray2D = targetSheet.getCellArray2D();
            if (0 == config.getExtractType()) {
                result.add(cellArray2D);
            } else {
                result.add(this.getCol(config.getHeadName(), cellArray2D, config.getExtractType()));
            }
        }
        return result;
    }

    private List<Object> getCol(String headName, ExcelCellInfo[][] cellArray2D, int type) {
        ArrayList<Object> result;
        block6: {
            ExcelCellInfo cellInfo;
            Integer targetY = null;
            Integer targetX = null;
            block0: for (int y = 0; y < cellArray2D.length; ++y) {
                for (int x = 0; x < cellArray2D[y].length; ++x) {
                    cellInfo = cellArray2D[y][x];
                    if (cellInfo == null || !MatchTextUtil.matchOld((String)headName, (String)cellInfo.getValueStr())) continue;
                    targetY = y;
                    targetX = x;
                    break block0;
                }
            }
            result = new ArrayList<Object>();
            if (targetY == null) break block6;
            if (1 == type) {
                ExcelCellInfo[] cellArray = cellArray2D[targetY];
                for (int x = targetX + 1; x < cellArray.length; ++x) {
                    ExcelCellInfo cellInfo2 = cellArray[x];
                    if (cellInfo2 == null) continue;
                    result.add(cellInfo2.getValue());
                }
            } else {
                for (int y = targetY + 1; y < cellArray2D.length; ++y) {
                    cellInfo = cellArray2D[y][targetX];
                    if (cellInfo == null) continue;
                    result.add(cellInfo.getValue());
                }
            }
        }
        return result;
    }
}

