/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.common.util.docparse.ReadPdfUtil;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrTextConfig;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractConfigEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor.AbstractItemExtractor;
import com.jxdinfo.idp.extract.thirdpartapi.OcrConfigServe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OcrItemExtractor
extends AbstractItemExtractor<FileBytesInfo, FileBytesInfo> {
    private static final Logger log = LoggerFactory.getLogger(OcrItemExtractor.class);
    private static JSONObject config = new JSONObject();
    private static JSONObject rules = new JSONObject();
    @Autowired
    private OcrConfigServe ocrConfigServe;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.OCR.getImplCode(), ItemExtractorEnum.OCR.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public FileBytesInfo before(FileBytesInfo bytesInfo) {
        return bytesInfo;
    }

    @Override
    public List<ExtractRecord> extract(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        ReadPdfUtil.removeTextWatermark((FileBytesInfo)bytesInfo);
        ArrayList<OcrTextConfig> texts = new ArrayList<OcrTextConfig>();
        ArrayList<JSONObject> tables = new ArrayList<JSONObject>();
        ArrayList<JSONObject> seals = new ArrayList<JSONObject>();
        ArrayList<JSONObject> signs = new ArrayList<JSONObject>();
        HashMap regexMap = new HashMap();
        for (ExtractItemDto dto : itemDtoList) {
            List relevancyList = dto.getTypeInfoList();
            List ocrTypeInfos = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.OCR.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(ocrTypeInfos)) continue;
            for (ExtractTypeInfo info : ocrTypeInfos) {
                String str;
                Object ocrJson;
                Map extractConfig;
                if (GroupLevel3Enum.OCR_SIMPLE.getCode().equals(info.getExtractType())) {
                    OcrTextConfig text = (OcrTextConfig)info.extractConfig(ExtractConfigEnum.extractConfig((String)info.getExtractType()));
                    text.setId(dto.getCode());
                    text.setKey(dto.getName());
                    if (StringUtils.isEmpty((Object)text.getIndex_trend())) {
                        text.setIndex_trend("left");
                    }
                    text.setElement_name(dto.getName());
                    if (CollUtil.isNotEmpty((Collection)text.getPattern())) {
                        regexMap.put(dto.getName(), text.getPattern().get(0));
                        text.setPattern(new ArrayList<String>(Collections.singletonList("(.*)")));
                    }
                    texts.add(text);
                    continue;
                }
                if (GroupLevel3Enum.OCR_SEAL.getCode().equals(info.getExtractType())) {
                    info.extractConfig();
                    extractConfig = info.getExtractConfig();
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        JSONObject seal = JSON.parseObject((String)ocrJson.toString());
                        seals.add(seal);
                        if (StringUtils.isEmpty(ocrJson)) continue;
                        seals.add(JSON.parseObject((String)ocrJson.toString()));
                    }
                    catch (Exception e) {
                        log.error("\u5370\u7ae0\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                    }
                    continue;
                }
                if (GroupLevel3Enum.OCR_SIGN.getCode().equals(info.getExtractType())) {
                    info.extractConfig();
                    extractConfig = info.getExtractConfig();
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        str = ocrJson.toString();
                        JSONObject sign = JSON.parseObject((String)str);
                        signs.add(sign);
                        if (StringUtils.isEmpty((Object)ocrJson)) continue;
                        signs.add(JSON.parseObject((String)ocrJson.toString()));
                    }
                    catch (Exception e) {
                        log.error("\u7b7e\u5b57\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                    }
                    continue;
                }
                if (!GroupLevel3Enum.OCR_TABLE.getCode().equals(info.getExtractType())) continue;
                info.extractConfig();
                extractConfig = info.getExtractConfig();
                try {
                    ocrJson = extractConfig;
                    str = ocrJson.toString();
                    if (StringUtils.isEmpty((Object)ocrJson)) continue;
                    JSONObject table = JSON.parseObject((String)ocrJson.toString());
                    table.put("element_name", (Object)dto.getName());
                    tables.add(table);
                }
                catch (Exception e) {
                    log.error("\u8868\u683c\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                }
            }
        }
        ArrayList<ExtractRecord> result = new ArrayList<ExtractRecord>();
        if (CollUtil.isNotEmpty(texts)) {
            rules.put("text", texts);
        }
        if (CollUtil.isNotEmpty(seals)) {
            rules.put("seal", seals);
        }
        if (CollUtil.isNotEmpty(tables)) {
            rules.put("table", tables);
        }
        if (CollUtil.isNotEmpty(signs)) {
            rules.put("sign", signs);
        }
        ConfigOcrResponse ocr = this.ocrConfigServe.ocr((Map)config, bytesInfo.getFileFormat(), bytesInfo.getFileBytes());
        for (ExtractItemDto dto : itemDtoList) {
            ExtractRecord record = new ExtractRecord();
            record.setExtractItemId(dto.getId());
            record.setItemName(dto.getName());
            Object ocrResult = ocr.get(dto.getName());
            String regex = (String)regexMap.get(dto.getName());
            if (!StringUtils.isEmpty((Object)regex) || ocrResult instanceof String) {
                List matchedList = MatchTextUtil.matchOld((String)regex, (Object)ocrResult);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < matchedList.size(); ++i) {
                    builder.append(matchedList.get(i));
                    if (i != matchedList.size() - 1) continue;
                    builder.append(" ");
                }
                builder = new StringBuilder(builder.toString().trim());
                ocrResult = builder.toString();
            }
            if (ocrResult != null) {
                record.setResult(JSON.toJSONString((Object)ocrResult));
            }
            record.setResultObject(ocrResult);
            result.add(record);
        }
        return result;
    }

    static {
        config.put("rules", (Object)rules);
        JSONObject globalParam = new JSONObject();
        config.put("global_param", (Object)globalParam);
        globalParam.put("pdf_num", (Object)99);
        globalParam.put("continuous_page_number", (Object)false);
        globalParam.put("recognitionRange", (Object)"0");
        JSONObject objectSetting = new JSONObject();
        globalParam.put("object_setting", (Object)objectSetting);
        objectSetting.put("seal_det", (Object)true);
        objectSetting.put("seal_det_thresh", (Object)0.5);
        objectSetting.put("sign_det", (Object)true);
        objectSetting.put("sign_det_thresh", (Object)0.5);
        objectSetting.put("writedate_det", (Object)false);
        objectSetting.put("writedate_det_thresh", (Object)0.5);
        objectSetting.put("writedate_rec", (Object)false);
        objectSetting.put("table_det", (Object)true);
        objectSetting.put("seal_elim", (Object)true);
        objectSetting.put("seal_elim_type", (Object)"unet");
        objectSetting.put("watermark_elim", (Object)false);
        objectSetting.put("watermark_elim_thresh", (Object)100);
        objectSetting.put("seal_rec", (Object)true);
    }
}

