/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelInfo;
import com.jxdinfo.idp.common.util.docparse.ReadExcelUtil;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor.AbstractItemExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.springframework.stereotype.Component;

@Component
public class ExcelItemExtractor
extends AbstractItemExtractor<FileBytesInfo, ExcelInfo> {
    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.EXCEL.getImplCode(), ItemExtractorEnum.EXCEL.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public ExcelInfo before(FileBytesInfo bytesInfo) {
        return ReadExcelUtil.getExcelInfo((FileBytesInfo)bytesInfo);
    }

    @Override
    public List<ExtractRecord> extract(ExcelInfo excelInfo, List<ExtractItemDto> itemDtoList) {
        ArrayList<ExtractItemDto> wordItemDtos = new ArrayList<ExtractItemDto>();
        for (ExtractItemDto dto : itemDtoList) {
            List relevancyList = dto.getTypeInfoList();
            List excelTypeRelevancyList = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.EXCEL.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(excelTypeRelevancyList)) continue;
            dto.setTypeInfoList(excelTypeRelevancyList);
            wordItemDtos.add(dto);
        }
        return super.extract(excelInfo, wordItemDtos);
    }
}

