/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.idp.common.base.dto.FileBytesInfo;
import com.jxdinfo.idp.common.base.dto.ImplCodeDto;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.dto.ExtractItemDto;
import com.jxdinfo.idp.extract.domain.dto.extractconfigOld.ocr.OcrTextConfig;
import com.jxdinfo.idp.extract.domain.po.ExtractRecord;
import com.jxdinfo.idp.extract.domain.po.ExtractTypeInfo;
import com.jxdinfo.idp.extract.domain.restTemplate.response.ConfigOcrResponse;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractConfigEnum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel2Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.GroupLevel3Enum;
import com.jxdinfo.idp.extract.extractorOld.enums.ItemExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.impl.itemexecutor.AbstractItemExtractor;
import com.jxdinfo.idp.extract.thirdpartapi.OcrConfigServe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class OcrItemExtractor
extends AbstractItemExtractor<FileBytesInfo, FileBytesInfo> {
    private static final Logger log = LoggerFactory.getLogger(OcrItemExtractor.class);
    private String old = "{\n    \"rules\": {\n        \"date\": [\n\n        ],\n        \"number\": [\n\n        ],\n        \"seal\": [\n\n        ],\n        \"sign\": [\n\n        ],\n        \"table\": [\n\n        ],\n        \"text\": [\n            {\n                \"element_name\": \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\",\n                \"extract_type\": \"text\",\n                \"sim_str\": \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\",\n                \"sim_rate\": 0.6,\n                \"index_trend\": \"left\",\n                \"index_start\": 0,\n                \"index_end\": 6,\n                \"row_skip\": 0,\n                \"pattern\": [\n                    \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\uff1a(.*)\"\n                ],\n                \"target_row\": 1,\n                \"specify_table\": \"\",\n                \"cell_keyword\": \"\",\n                \"right_move\": 0,\n                \"down_move\": 0,\n                \"cell_pattern\": \"\",\n                \"id\": \"7dafbac90d9640d391ea66b0538b51e5\",\n                \"handleType\": \"text\",\n                \"key\": \"\u9879\u76ee\u7533\u62a5\u5355\u4f4d\",\n                \"text_pattern\": [\n\n                ],\n                \"text_process\": \"1\",\n                \"replace\": false,\n                \"target_way\": \"ind\",\n                \"skip_way\": \"3\",\n                \"rightMoveFlag\": \"right\",\n                \"downMoveFlag\": \"down\",\n                \"fromTabFlag\": \"0\"\n            },\n            {\n                \"element_name\": \"\u7f16\u5236\u5355\u4f4d\",\n                \"extract_type\": \"text\",\n                \"sim_str\": \"\u7f16\u5236\u5355\u4f4d\",\n                \"sim_rate\": 0.6,\n                \"index_trend\": \"left\",\n                \"index_start\": 0,\n                \"index_end\": 4,\n                \"row_skip\": 0,\n                \"pattern\": [\n                    \"\u7f16\u5236\u5355\u4f4d\uff1a(.*)\"\n                ],\n                \"target_row\": 4,\n                \"specify_table\": \"\",\n                \"cell_keyword\": \"\",\n                \"right_move\": 0,\n                \"down_move\": 0,\n                \"cell_pattern\": \"\",\n                \"id\": \"d3475eacbddb4ff4ba39ab01f51a5076\",\n                \"handleType\": \"text\",\n                \"key\": \"\u7f16\u5236\u5355\u4f4d\",\n                \"text_pattern\": [\n\n                ],\n                \"text_process\": \"1\",\n                \"replace\": false,\n                \"target_way\": \"ind\",\n                \"skip_way\": \"3\",\n                \"rightMoveFlag\": \"right\",\n                \"downMoveFlag\": \"down\",\n                \"fromTabFlag\": \"0\"\n            },\n            {\n                \"element_name\": \"\u5ba1\u6838\u4eba\",\n                \"extract_type\": \"text\",\n                \"sim_str\": \"\u5ba1 \u6838\uff1a\u5468\u6cfd\u5b8f\",\n                \"sim_rate\": 0.6,\n                \"index_trend\": \"left\",\n                \"index_start\": 0,\n                \"index_end\": 7,\n                \"row_skip\": 0,\n                \"pattern\": [\n                    \"\u5ba1  \u6838\uff1a(.*)\"\n                ],\n                \"target_row\": 1,\n                \"specify_table\": \"\",\n                \"cell_keyword\": \"\",\n                \"right_move\": 0,\n                \"down_move\": 0,\n                \"cell_pattern\": \"\",\n                \"id\": \"e075ad4a84432826e75369c369f73716\",\n                \"handleType\": \"text\",\n                \"key\": \"\u5ba1\u6838\u4eba\",\n                \"text_pattern\": [\n\n                ],\n                \"text_process\": \"1\",\n                \"replace\": false,\n                \"target_way\": \"ind\",\n                \"skip_way\": \"3\",\n                \"rightMoveFlag\": \"right\",\n                \"downMoveFlag\": \"down\",\n                \"fromTabFlag\": \"0\"\n            }\n        ],\n        \"writedate\": [\n\n        ],\n        \"defined_table\": [\n\n        ]\n    }\n}";
    private String extractJsonStr = "{\"rules\":{\"date\":[],\"number\":[],\"seal\":[],\"sign\":[],\"table\":[],\"text\":[],\"writedate\":[],\"defined_table\":[]}}";
    private String identifyJson = "{\"global_param\":{\"pdf_num\":99,\"continuous_page_number\":false,\"recognitionRange\":\"0\",\"object_setting\":{\"seal_det\":true,\"seal_det_thresh\":0.5,\"sign_det\":true,\"sign_det_thresh\":0.5,\"writedate_det\":false,\"writedate_det_thresh\":0.5,\"writedate_rec\":false,\"table_det\":false,\"seal_elim\":true,\"seal_elim_type\":\"unet\",\"watermark_elim\":false,\"watermark_elim_thresh\":100,\"seal_rec\":true}}}";
    @Autowired
    private OcrConfigServe ocrConfigServe;

    @Override
    public ImplCodeDto implCodeDto() {
        return new ImplCodeDto(ItemExtractorEnum.OCR.getImplCode(), ItemExtractorEnum.OCR.getImplName());
    }

    @Override
    @PostConstruct
    public void init() {
        super.init();
    }

    @Override
    public FileBytesInfo before(FileBytesInfo bytesInfo) {
        return bytesInfo;
    }

    @Override
    public List<ExtractRecord> extract(FileBytesInfo bytesInfo, List<ExtractItemDto> itemDtoList) {
        ArrayList<OcrTextConfig> texts = new ArrayList<OcrTextConfig>();
        ArrayList tables = new ArrayList();
        ArrayList<JSONObject> seals = new ArrayList<JSONObject>();
        ArrayList<JSONObject> signs = new ArrayList<JSONObject>();
        HashMap regexMap = new HashMap();
        for (ExtractItemDto dto : itemDtoList) {
            List relevancyList = dto.getTypeInfoList();
            List ocrTypeInfos = relevancyList.stream().filter(typeInfo -> GroupLevel2Enum.OCR.equals((Object)GroupLevel3Enum.get((String)typeInfo.getExtractType()).getLevel2Enum())).collect(Collectors.toList());
            if (!CollUtil.isNotEmpty(ocrTypeInfos)) continue;
            for (ExtractTypeInfo info : ocrTypeInfos) {
                String str;
                Object ocrJson;
                Map extractConfig;
                if (GroupLevel3Enum.OCR_SIMPLE.getCode().equals(info.getExtractType())) {
                    OcrTextConfig text = (OcrTextConfig)info.extractConfig(ExtractConfigEnum.extractConfig((String)info.getExtractType()));
                    text.setId(dto.getCode());
                    text.setKey(dto.getName());
                    if (StringUtils.isEmpty((Object)text.getIndex_trend())) {
                        text.setIndex_trend("left");
                    }
                    text.setElement_name(dto.getName());
                    if (CollUtil.isNotEmpty((Collection)text.getPattern())) {
                        regexMap.put(dto.getName(), text.getPattern().get(0));
                        text.setPattern(new ArrayList<String>(Collections.singletonList("(.*)")));
                    }
                    texts.add(text);
                    continue;
                }
                if (GroupLevel3Enum.OCR_SEAL.getCode().equals(info.getExtractType())) {
                    info.extractConfig();
                    extractConfig = info.getExtractConfig();
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        JSONObject seal = JSON.parseObject((String)ocrJson.toString());
                        seals.add(seal);
                        if (StringUtils.isEmpty(ocrJson)) continue;
                        seals.add(JSON.parseObject((String)ocrJson.toString()));
                    }
                    catch (Exception e) {
                        log.error("\u5370\u7ae0\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                    }
                    continue;
                }
                if (GroupLevel3Enum.OCR_SIGN.getCode().equals(info.getExtractType())) {
                    info.extractConfig();
                    extractConfig = info.getExtractConfig();
                    try {
                        ocrJson = extractConfig.get("ocrJson");
                        str = ocrJson.toString();
                        JSONObject sign = JSON.parseObject((String)str);
                        signs.add(sign);
                        if (StringUtils.isEmpty((Object)ocrJson)) continue;
                        signs.add(JSON.parseObject((String)ocrJson.toString()));
                    }
                    catch (Exception e) {
                        log.error("\u7b7e\u5b57\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                    }
                    continue;
                }
                if (!GroupLevel3Enum.OCR_TABLE.getCode().equals(info.getExtractType())) continue;
                info.extractConfig();
                extractConfig = info.getExtractConfig();
                try {
                    ocrJson = extractConfig;
                    str = ocrJson.toString();
                    JSONObject table = JSON.parseObject((String)str);
                    table.put("element_name", (Object)info.getName());
                    signs.add(table);
                    if (StringUtils.isEmpty((Object)ocrJson)) continue;
                    signs.add(JSON.parseObject((String)ocrJson.toString()));
                }
                catch (Exception e) {
                    log.error("\u8868\u683c\u914d\u7f6e\u6709\u8bef", (Throwable)e);
                }
            }
        }
        ArrayList<ExtractRecord> result = new ArrayList<ExtractRecord>();
        HashMap map = new HashMap(JSON.parseObject((String)this.identifyJson));
        JSONObject extractJson = JSON.parseObject((String)this.extractJsonStr);
        JSONObject rules = extractJson.getJSONObject("rules");
        if (CollUtil.isNotEmpty(texts)) {
            rules.put("text", texts);
        }
        if (CollUtil.isNotEmpty(seals)) {
            rules.put("seal", seals);
        }
        if (CollUtil.isNotEmpty(tables)) {
            rules.put("tables", tables);
        }
        if (CollUtil.isNotEmpty(signs)) {
            rules.put("sign", signs);
        }
        map.putAll(extractJson);
        ConfigOcrResponse ocr = this.ocrConfigServe.ocr(map, bytesInfo.getFileFormat(), bytesInfo.getFileBytes());
        for (ExtractItemDto dto : itemDtoList) {
            ExtractRecord record = new ExtractRecord();
            record.setExtractItemId(dto.getId());
            record.setItemName(dto.getName());
            Object ocrResult = ocr.get(dto.getName());
            String regex = (String)regexMap.get(dto.getName());
            if (!StringUtils.isEmpty((Object)regex) || ocrResult instanceof String) {
                List matchedList = MatchTextUtil.matchOld((String)regex, (Object)ocrResult);
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < matchedList.size(); ++i) {
                    builder.append(matchedList.get(i));
                    if (i != matchedList.size() - 1) continue;
                    builder.append(" ");
                }
                builder = new StringBuilder(builder.toString().trim());
                ocrResult = builder.toString();
            }
            if (ocrResult != null) {
                record.setResult(JSON.toJSONString((Object)ocrResult));
            }
            record.setResultObject(ocrResult);
            result.add(record);
        }
        return result;
    }
}

