/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.excel;

import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.config.excel.ExcelTextConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Excel-\u6587\u672c\u63d0\u53d6", order=4)
public class ExcelTextExtractor
extends AbstractDefaultExtractor<ExcelSheetInfo, String, ExcelTextConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.EXCEL_TEXT;
    }

    @Override
    public Class<?> outputClass() {
        return String.class;
    }

    @Override
    protected CategoryDto categoryDto() {
        return this.stringCategoryDto();
    }

    @Override
    public List<String> extract(List<ExcelSheetInfo> sheetInfos, ExcelTextConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        for (ExcelSheetInfo sheetInfo : sheetInfos) {
            ExcelCellInfo[][] cellArray2D = sheetInfo.getCellArray2D();
            for (int y = 0; y < cellArray2D.length; ++y) {
                for (int x = 0; x < cellArray2D[y].length; ++x) {
                    ExcelCellInfo cellInfo = cellArray2D[y][x];
                    if (!MatchTextUtil.isMatch((String)config.getBasicRegex(), (String)cellInfo.getValueStr()).booleanValue()) continue;
                    try {
                        ExcelCellInfo target = cellArray2D[y + config.getOffsetY()][x + config.getOffsetX()];
                        result.addAll(MatchTextUtil.match((String)config.getRegex(), (String)target.getValueStr()));
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    @Override
    public ExtractorCarrier<String> outPut(List<ExcelSheetInfo> sheetInfos, ExcelTextConfig config) {
        ArrayList data = new ArrayList();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (ExcelSheetInfo sheetInfo : sheetInfos) {
            ExcelCellInfo[][] cellArray2D = sheetInfo.getCellArray2D();
            for (int y = 0; y < cellArray2D.length; ++y) {
                for (int x = 0; x < cellArray2D[y].length; ++x) {
                    ExcelCellInfo cellInfo = cellArray2D[y][x];
                    if (!MatchTextUtil.isMatch((String)config.getBasicRegex(), (String)cellInfo.getValueStr()).booleanValue()) continue;
                    try {
                        ExcelCellInfo target = cellArray2D[y + config.getOffsetY()][x + config.getOffsetX()];
                        data.addAll(MatchTextUtil.match((String)config.getRegex(), (String)target.getValueStr()));
                        locations.add(new Location());
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        return this.carrier(data, locations);
    }
}

