/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.thirdpartapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.GPTPackagingParamDTO;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.GPTSseParamDTO;
import com.jxdinfo.idp.extract.domain.restTemplate.nlp.Knowledge;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.sse.RealEventSource;
import okhttp3.sse.EventSource;
import okhttp3.sse.EventSourceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Component
public class NLPParseServer {
    private static final Logger log = LoggerFactory.getLogger(NLPParseServer.class);
    @Value(value="${rmi.largeModel.url}")
    private String url;
    @Value(value="${rmi.largeModel.api.nlp}")
    private String api;
    OkHttpClient.Builder client;
    MediaType mediaType;
    Request.Builder requestBuilder;
    public static final String ERROR_RESPONSE = "\u5f88\u62b1\u6b49\uff0c\u5f53\u524d\u95ee\u7b54\u65e0\u54cd\u5e94\u3002\u60a8\u53ef\u4ee5\u518d\u6b21\u5c1d\u8bd5\uff0c\u6211\u5c06\u7aed\u8bda\u4e3a\u60a8\u670d\u52a1\u3002";

    @PostConstruct
    public void init() {
        this.mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        this.requestBuilder = new Request.Builder().url(this.url + this.api);
        this.client = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.MINUTES);
    }

    public String chat(Knowledge knowledge, final SseEmitter emitter, final GPTPackagingParamDTO param) throws InterruptedException {
        Request request = this.requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)JSON.toJSONString((Object)knowledge))).build();
        OkHttpClient okHttpClient = this.client.build();
        RealEventSource realEventSource = null;
        String answer = "";
        final StringBuffer answerBuffer = new StringBuffer();
        final CountDownLatch eventLatch = new CountDownLatch(1);
        realEventSource = new RealEventSource(request, new EventSourceListener(){

            public void onOpen(EventSource eventSource, Response response) {
                log.info("--\u4e0e\u5927\u8bed\u8a00\u6a21\u578b\u5efa\u7acb\u8fde\u63a5--");
            }

            public void onEvent(EventSource eventSource, @Nullable String id, @Nullable String type, String data) {
                try {
                    GPTSseParamDTO sseParam = (GPTSseParamDTO)JSON.parseObject((String)data, GPTSseParamDTO.class);
                    answerBuffer.append(sseParam.getMessage());
                    sseParam.setAskTime(param.getAskTime());
                    emitter.send(SseEmitter.event().name("add").data((Object)sseParam));
                }
                catch (JSONException e) {
                    log.error("\u5927\u8bed\u8a00\u6a21\u578b\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException("\u670d\u52a1\u5f02\u5e38");
                }
                catch (Exception e) {
                    log.error("\u6d41\u5f0f\u54cd\u5e94\u6570\u636e\u63a5\u6536\u5f02\u5e38", (Throwable)e);
                    throw new RuntimeException("\u670d\u52a1\u5f02\u5e38");
                }
            }

            public void onClosed(EventSource eventSource) {
                log.info("--\u4e0e\u5927\u8bed\u8a00\u6a21\u578b\u65ad\u5f00\u8fde\u63a5--");
                emitter.complete();
                eventLatch.countDown();
            }

            public void onFailure(EventSource eventSource, @Nullable Throwable t, @Nullable Response response) {
                String[] errResp;
                log.error("GPT\u63a5\u53e3SseEmitter\u670d\u52a1\u5f02\u5e38", t);
                answerBuffer.setLength(0);
                answerBuffer.append(NLPParseServer.ERROR_RESPONSE);
                for (String s : errResp = NLPParseServer.ERROR_RESPONSE.split("")) {
                    GPTSseParamDTO sseParam = new GPTSseParamDTO();
                    sseParam.setMessage(s);
                    sseParam.setAskTime(param.getAskTime());
                    try {
                        emitter.send(SseEmitter.event().name("add").data((Object)sseParam));
                    }
                    catch (IOException e) {
                        emitter.complete();
                        eventLatch.countDown();
                    }
                }
                emitter.complete();
                eventLatch.countDown();
            }
        });
        realEventSource.connect(okHttpClient);
        eventLatch.await();
        if (StringUtils.isEmpty((CharSequence)answerBuffer.toString())) {
            answerBuffer.append(ERROR_RESPONSE);
        }
        answer = answerBuffer.toString();
        return answer;
    }
}

