/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.excel;

import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.config.excel.ExcelSheetConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Excel-sheet\u63d0\u53d6", order=2)
public class ExcelSheetExtractor
extends AbstractDefaultExtractor<ExcelInfo, ExcelSheetInfo, ExcelSheetConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.EXCEL_SHEET;
    }

    @Override
    protected List<ExcelSheetInfo> extract(List<ExcelInfo> input, ExcelSheetConfig config) {
        ArrayList<ExcelSheetInfo> result = new ArrayList<ExcelSheetInfo>();
        for (ExcelInfo excelInfo : input) {
            for (ExcelSheetInfo sheetInfo : excelInfo.getSheetInfos()) {
                if (!MatchTextUtil.isMatch((String)config.getRegex(), (String)sheetInfo.getName()).booleanValue()) continue;
                result.add(sheetInfo);
            }
        }
        return result;
    }

    @Override
    public Class<ExcelSheetInfo> outputClass() {
        return ExcelSheetInfo.class;
    }

    @Override
    public ExtractorCarrier<ExcelSheetInfo> outPut(List<ExcelInfo> input, ExcelSheetConfig config) {
        ArrayList<ExcelSheetInfo> data = new ArrayList<ExcelSheetInfo>();
        ArrayList<Location> locations = new ArrayList<Location>();
        for (ExcelInfo excelInfo : input) {
            for (ExcelSheetInfo sheetInfo : excelInfo.getSheetInfos()) {
                if (!MatchTextUtil.isMatch((String)config.getRegex(), (String)sheetInfo.getName()).booleanValue()) continue;
                data.add(sheetInfo);
                locations.add(new Location());
            }
        }
        return this.carrier(data, locations);
    }
}

