/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.excel;

import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelCellInfo;
import com.jxdinfo.idp.common.entity.util.docparse.excel.ExcelSheetInfo;
import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.config.excel.ExcelRowAndColConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorCarrier;
import com.jxdinfo.idp.extract.domain.location.Location;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractor.defaults.AbstractDefaultExtractor;
import com.jxdinfo.idp.extract.extractor.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import com.jxdinfo.idp.model.base.dto.CategoryDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
@Extractor(group=ExtractorGroupEnum.DOCUMENT_PARSE, name="Excel-\u884c\u5217\u63d0\u53d6", order=3)
public class ExcelRowAndColExtractor
extends AbstractDefaultExtractor<ExcelSheetInfo, String, ExcelRowAndColConfig> {
    @Override
    public ExtractorEnum extractorEnum() {
        return ExtractorEnum.EXCEL_ROW_COL;
    }

    @Override
    public Class<?> outputClass() {
        return String.class;
    }

    @Override
    protected CategoryDto categoryDto() {
        return this.stringCategoryDto();
    }

    @Override
    public ExtractorCarrier<String> outPut(List<ExcelSheetInfo> excelSheetInfos, ExcelRowAndColConfig config) {
        ArrayList<String> result = new ArrayList<String>();
        block2: for (ExcelSheetInfo sheetInfo : excelSheetInfos) {
            if ("row".equals(config.getRowOrCol())) {
                for (ExcelCellInfo[] rows : sheetInfo.getCellArray2D()) {
                    ExcelCellInfo cell = rows[0];
                    String valueStr = cell.getValueStr();
                    if (!MatchTextUtil.matchOld((String)config.getHead(), (String)valueStr)) continue;
                    for (int i = 1; i < rows.length; ++i) {
                        result.add(rows[i].getValueStr());
                    }
                }
                continue;
            }
            if (!"col".equals(config.getRowOrCol())) continue;
            ExcelCellInfo[] cells = sheetInfo.getCellArray2D()[0];
            for (int i = 0; i < cells.length; ++i) {
                ExcelCellInfo cell = cells[i];
                String valueStr = cell.getValueStr();
                if (!MatchTextUtil.matchOld((String)config.getHead(), (String)valueStr)) continue;
                for (int y = 1; y < sheetInfo.getCellArray2D().length; ++y) {
                    try {
                        ExcelCellInfo cellInfo = sheetInfo.getCellArray2D()[y][i];
                        result.add(cellInfo.getValueStr());
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                continue block2;
            }
        }
        return this.carrier(result, new ArrayList<Location>());
    }
}

