/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.extractor.defaults.ocr;

import com.jxdinfo.idp.common.util.docparse.MatchTextUtil;
import com.jxdinfo.idp.extract.domain.configOld.ocr.OcrParaConfig;
import com.jxdinfo.idp.extract.domain.extractor.ExtractorIntiInfo;
import com.jxdinfo.idp.extract.domain.util.OcrInfo;
import com.jxdinfo.idp.extract.domain.util.ocr.OcrParagraph;
import com.jxdinfo.idp.extract.enums.ExtractorEnum;
import com.jxdinfo.idp.extract.extractorOld.AbstractExtractor;
import com.jxdinfo.idp.extract.extractorOld.enums.ExtractorGroupEnum;
import com.jxdinfo.idp.extract.params.annotation.Extractor;
import java.util.ArrayList;
import java.util.List;

@Extractor(group=ExtractorGroupEnum.OCR, name="OCR-\u6bb5\u843d\u63d0\u53d6", order=22)
public class OcrParagraphExtractor
extends AbstractExtractor<OcrInfo, OcrParagraph, OcrParaConfig> {
    @Override
    public ExtractorIntiInfo init() {
        return new ExtractorIntiInfo(ExtractorEnum.OCR_INFO.getCode(), ExtractorEnum.OCR_PARA.getCode());
    }

    @Override
    public List<OcrParagraph> extract(List<OcrInfo> ocrInfos, OcrParaConfig config) {
        ArrayList<OcrParagraph> result = new ArrayList<OcrParagraph>();
        for (OcrInfo ocrInfo : ocrInfos) {
            for (OcrParagraph paragraph : ocrInfo.getParagraphs()) {
                if (!MatchTextUtil.isMatch((String)config.getRegex(), (String)paragraph.getText()).booleanValue()) continue;
                result.add(paragraph);
            }
        }
        return result;
    }
}

