/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.idp.extract.chain.common;

import com.jxdinfo.idp.common.exception.BusinessException;
import com.jxdinfo.idp.extract.chain.dto.ExtractChain;
import com.jxdinfo.idp.extract.chain.dto.ExtractLink;
import com.jxdinfo.idp.extract.chain.dto.ExtractNode;
import com.jxdinfo.idp.extract.chain.dto.ResultDataCategory;
import com.jxdinfo.idp.flow.config.model.IdpFlowLink;
import com.jxdinfo.idp.flow.config.model.IdpFlowTag;
import com.jxdinfo.idp.flow.parser.entity.FlowData;
import com.jxdinfo.idp.flow.parser.entity.edge.Edge;
import com.jxdinfo.idp.flow.parser.entity.edge.EdgeData;
import com.jxdinfo.idp.flow.parser.entity.node.Node;
import com.jxdinfo.idp.flow.parser.entity.node.NodeData;
import com.jxdinfo.idp.flow.parser.entity.node.NodeDataBase;
import com.jxdinfo.idp.flow.parser.enums.IvyEnums;
import com.jxdinfo.idp.flow.parser.execption.FlowELException;
import com.jxdinfo.idp.flow.parser.graph.Graph;
import com.jxdinfo.idp.flow.parser.graph.GraphInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;

public class ChainUtils {
    public static String toEL(ExtractChain extractChain) throws FlowELException {
        if (CollectionUtils.isEmpty((Collection)extractChain.getNodes())) {
            throw new BusinessException("\u63d0\u53d6\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (extractChain.getNodes().size() >= 2 && CollectionUtils.isEmpty((Collection)extractChain.getLinks())) {
            throw new BusinessException("\u63d0\u53d6\u8282\u70b9\u8fde\u63a5\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FlowData flowData = new FlowData();
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Edge> edges = new ArrayList<Edge>();
        for (ExtractNode extractNode : extractChain.getNodes()) {
            Node node = new Node();
            node.setId(extractNode.getId());
            node.setType(IvyEnums.PATH_ENUM.common_path.value());
            NodeData nodeData = new NodeData();
            nodeData.setId(extractNode.getType());
            NodeDataBase nodeDataBase = new NodeDataBase();
            nodeDataBase.setTag(extractNode.getId());
            nodeData.setNodeDataBase(nodeDataBase);
            node.setData(nodeData);
            nodes.add(node);
        }
        for (ExtractLink link : extractChain.getLinks()) {
            Edge edge = new Edge();
            edge.setSource(link.getSourceId());
            edge.setTarget(link.getTargetId());
            EdgeData edgeData = new EdgeData();
            edgeData.setType(IvyEnums.PATH_ENUM.common_path.value());
            edge.setData(edgeData);
            edges.add(edge);
        }
        flowData.setNodes(nodes);
        flowData.setEdges(edges);
        Graph graph = new Graph(flowData);
        GraphInfo graphInfo = graph.toELInfo();
        return graphInfo.toString();
    }

    public static IdpFlowTag nodeToTag(ExtractNode node) {
        IdpFlowTag tag = new IdpFlowTag();
        tag.setId(node.getId());
        tag.setName(node.getName());
        tag.setType(node.getType());
        tag.setConfigParams(node.getConfig());
        tag.setInputType(node.getInputType());
        tag.setInputData(node.getInputData());
        if (node.getCategory() != null) {
            tag.setCategoryId(node.getCategory().getId());
        }
        return tag;
    }

    public static List<IdpFlowTag> nodeToTagBatch(List<ExtractNode> nodes) {
        ArrayList<IdpFlowTag> tags = new ArrayList<IdpFlowTag>();
        for (ExtractNode node : nodes) {
            tags.add(ChainUtils.nodeToTag(node));
        }
        return tags;
    }

    public static ExtractNode tagToNode(IdpFlowTag tag) {
        ExtractNode node = new ExtractNode();
        node.setId(tag.getId());
        node.setName(tag.getName());
        node.setType(tag.getType());
        node.setConfig(tag.getConfigParams());
        node.setInputType(tag.getInputType());
        node.setInputData(tag.getInputData());
        if (tag.getCategoryId() != null) {
            ResultDataCategory dataCategory = new ResultDataCategory();
            dataCategory.setId(tag.getCategoryId());
            node.setCategory(dataCategory);
        }
        return node;
    }

    public static List<ExtractNode> tagToNodeBatch(List<IdpFlowTag> tags) {
        ArrayList<ExtractNode> nodes = new ArrayList<ExtractNode>();
        for (IdpFlowTag tag : tags) {
            nodes.add(ChainUtils.tagToNode(tag));
        }
        return nodes;
    }

    public static IdpFlowLink linkToFlowLink(ExtractLink link) {
        IdpFlowLink idpFlowLink = new IdpFlowLink();
        idpFlowLink.setId(link.getId());
        idpFlowLink.setSourceId(link.getSourceId());
        idpFlowLink.setTargetId(link.getTargetId());
        return idpFlowLink;
    }

    public static List<IdpFlowLink> linkToFlowLinkBatch(List<ExtractLink> links) {
        ArrayList<IdpFlowLink> idpFlowLinks = new ArrayList<IdpFlowLink>();
        for (ExtractLink link : links) {
            idpFlowLinks.add(ChainUtils.linkToFlowLink(link));
        }
        return idpFlowLinks;
    }

    public static ExtractLink flowLinkToLink(IdpFlowLink link) {
        ExtractLink extractLink = new ExtractLink();
        extractLink.setId(link.getId());
        extractLink.setSourceId(link.getSourceId());
        extractLink.setTargetId(link.getTargetId());
        return extractLink;
    }

    public static List<ExtractLink> flowLinkToLinkBatch(List<IdpFlowLink> links) {
        ArrayList<ExtractLink> extractLinks = new ArrayList<ExtractLink>();
        for (IdpFlowLink link : links) {
            extractLinks.add(ChainUtils.flowLinkToLink(link));
        }
        return extractLinks;
    }

    public static List<ExtractNode> getSingleNode(ExtractChain extractChain) {
        ArrayList<ExtractNode> singleNodes = new ArrayList<ExtractNode>();
        List nodes = extractChain.getNodes();
        List links = extractChain.getLinks();
        for (ExtractNode node : nodes) {
            if (!links.stream().noneMatch(link -> Objects.equals(link.getSourceId(), node.getId()) || Objects.equals(link.getTargetId(), node.getId()))) continue;
            singleNodes.add(node);
        }
        return singleNodes;
    }

    public static List<ExtractNode> getFinalNode(ExtractChain extractChain) {
        ArrayList<ExtractNode> finalNodes = new ArrayList<ExtractNode>();
        List nodes = extractChain.getNodes();
        List links = extractChain.getLinks();
        for (ExtractNode node : nodes) {
            if (!links.stream().noneMatch(link -> Objects.equals(link.getSourceId(), node.getId()))) continue;
            finalNodes.add(node);
        }
        return finalNodes;
    }
}

